/********** RangeDateTime.C *******************************************************************************************\

 $Header$

 REVISION HISTORY
   06/99  Tom Lauren
   08/99  Charles Cavanaugh
   01/02  Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "RangeDateTime.h"
#include <string.h>

range_date_time :: range_date_time ()
                 : attribute_group (),
                   date_time_group ()
{
  rangeendingdate    [0] = '\0';
  rangeendingtime    [0] = '\0';
  rangebeginningdate [0] = '\0';
  rangebeginningtime [0] = '\0';
}


range_date_time :: ~range_date_time ()
{
  ;
}


bool range_date_time :: Set (PGSt_MET_handle handle, mopitt_time const& starttime, mopitt_time const& stoptime)
{
  bool isset = false;

  // retrieve the ending time info
  GetDate (stoptime.GetUTC (), rangeendingdate);
  GetTime (stoptime.GetUTC (), rangeendingtime);

  // retrieve the beginning time info
  GetDate (starttime.GetUTC (), rangebeginningdate);
  GetTime (starttime.GetUTC (), rangebeginningtime);
  
  // control rangeendingdate = rangebeginningdate
  if ( int issamedate = strcmp ( rangebeginningdate, rangeendingdate ) != 0 ) {
    (void) strcpy ( rangeendingdate, rangebeginningdate );
    (void) strcpy ( rangeendingtime, "23:59:59.999" );
  }

  // sptr is necessary for some bizarre toolkit reason.
  char* sptr;

  sptr = rangeendingdate;
  if (attribute_group::Set (handle, "RangeEndingDate", (void*) &sptr)) {

    sptr = rangeendingtime;
    if (attribute_group::Set (handle, "RangeEndingTime", (void*) &sptr)) {

      sptr = rangebeginningdate;
      if (attribute_group::Set (handle, "RangeBeginningDate", (void*) &sptr)) {

        sptr = rangebeginningtime;
        if (attribute_group::Set (handle, "RangeBeginningTime", (void*) &sptr))
          isset = true;
      }
    }
  }

  return isset;
}
