/********** QAStats.C *************************************************************************************************\

 $Header$

 REVISION HISTORY
   06/99  Tom Lauren
   08/99  Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "QAStats.h"

qa_stats :: qa_stats ()
          : attribute_group ()
{
  ;
}


qa_stats :: ~qa_stats ()
{
  ;
}


bool qa_stats :: Set (PGSt_MET_handle handle, int parameternumber, int missing, int outofbounds, int interpolated)
{
  bool isset = false;

  // set the values
  qapercentmissingdata = missing;
  qapercentoutofboundsdata = outofbounds;
  qapercentcloudcover = 42;
  qapercentinterpolateddata = interpolated;

  // store the values, but first make the attribute names
  char attributename [50];

  (void) sprintf (attributename, "QAPercentMissingData.%d", parameternumber);
  if (attribute_group::Set (handle, attributename, (void*) &qapercentmissingdata)) { 
    
    (void) sprintf (attributename, "QAPercentOutofBoundsData.%d", parameternumber);
    if (attribute_group::Set (handle, attributename, (void*) &qapercentoutofboundsdata)) {

      (void) sprintf (attributename, "QAPercentCloudCover.%d", parameternumber);
      if (attribute_group::Set (handle, attributename, (void*) &qapercentcloudcover)) {

        (void) sprintf (attributename, "QAPercentInterpolatedData.%d", parameternumber);
        if (attribute_group::Set (handle, attributename, (void*) &qapercentinterpolateddata))
          isset = true;
      }
    }
  }

  return isset;
}
