/********** QAFlags.C *************************************************************************************************\

 $Header$

 REVISION HISTORY
   06/99  Tom Lauren
   08/99  Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "QAFlags.h"

qa_flags :: qa_flags ()
          : attribute_group ()
{
  automaticqualityflagexplanation   [0] = '\0';
  automaticqualityflag              [0] = '\0';
  operationalqualityflagexplanation [0] = '\0';
  operationalqualityflag            [0] = '\0';
}


qa_flags :: ~qa_flags ()
{
  ;
}


bool qa_flags :: Set (PGSt_MET_handle handle, int parameternumber)
{
  bool isset = false;

  // set the flags
  (void) strcpy (automaticqualityflagexplanation, 
                 "Process Terminated Normally - Check Science Quality Flag for Science Team quality assessment");
  (void) strcpy (automaticqualityflag, "Suspect");
  (void) strcpy (operationalqualityflagexplanation,
                 "Process Terminated Normally - Check Science Quality Flag for Science Team quality assessment");
  (void) strcpy (operationalqualityflag, "Being Investigated");

  // sptr is necessary for some bizarre toolkit reason.
  char* sptr;
  char attributename [50];

  sptr = automaticqualityflagexplanation;
  (void) sprintf (attributename, "AutomaticQualityFlagExplanation.%d", parameternumber);
  if (attribute_group::Set (handle, attributename, (void*) &sptr)) {

    sptr = automaticqualityflag;
    (void) sprintf (attributename, "AutomaticQualityFlag.%d", parameternumber);
    if (attribute_group::Set (handle, attributename, (void*) &sptr)) {

      sptr = operationalqualityflagexplanation;
      (void) sprintf (attributename, "OperationalQualityFlagExplanation.%d", parameternumber);
      if (attribute_group::Set (handle, attributename, (void*) &sptr)) {

        sptr = operationalqualityflag;
        (void) sprintf (attributename, "OperationalQualityFlag.%d", parameternumber);
        if (attribute_group::Set (handle, attributename, (void*) &sptr))
          isset = true;
      }
    }
  }

  return isset;
}
