/********** PSAGroup.C ************************************************************************************************\

 $Header$

 REVISION HISTORY
   06/99  Tom Lauren
   08/99  Charles Cavanaugh
   09/99  Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "PSAGroup.h"
#include "MetadataConstants.h"

psa_group :: psa_group ()
           : attribute_group ()
{
  counter = 1;
}


psa_group :: ~psa_group ()
{
  ;
}


bool psa_group :: Set (PGSt_MET_handle handle, char const* const attrname, void const* const attrval)
{
  bool isset = false;

  // set the attribute name and write it
  char attributename [35];
  (void) sprintf (attributename, "AdditionalAttributeName.%d", counter);
  char* sptr = (char*) attrname;
  if (attribute_group::Set (handle, attributename, (void*) &sptr)) {

    // set the parameter value and write it
    (void) sprintf (attributename, "ParameterValue.%d", counter);
    if (attribute_group::Set (handle, attributename, (void*) attrval)) {
      counter++;
      isset = true;
    }
  }

  return isset;
}
