/********** PGEVersionClass.C *****************************************************************************************\

 $Header$

 REVISION HISTORY
   06/99  Tom Lauren
   08/99  Charles Cavanaugh
   06/00  Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include <string.h>
#include "PGEVersionClass.h"
#include "DiagnosticReporter.h"

extern diagnostic_reporter diagnosticreporter;

pge_version_class :: pge_version_class ()
                   : attribute_group ()
{
  pgeversion [0] = '\0';
}


pge_version_class :: ~pge_version_class ()
{
  ;
}


void pge_version_class :: ExtractVersion (char fullname [], char extracted []) const
{
  // save the full name (so it wont get mangled)
  char newfullname [PGSd_PC_FILE_PATH_MAX];
  char filename [PGSd_PC_FILE_PATH_MAX];
  (void) strcpy (newfullname, fullname);

  // recover the filename by parsing the full name with '/' as a token delimiter
  char* token = strtok (newfullname, "/");
  (void) strcpy (filename, token);
  while ((token = strtok (NULL, "/")) != NULL) {
    (void) strcpy (filename, token);
  }

  // extract the version info
  char* version = strstr (filename, "L1V");
  token = strtok (version, "V");
  token = strtok (NULL, "");
  (void) strncpy (extracted, token, strlen (token) - 4);
  extracted [strlen (token) - 4] = '\0';
}


bool pge_version_class :: Set (PGSt_MET_handle handle, PGSt_PC_Logical filelogical)
{
  bool isset = false;

  // get the filename from the filelogical
  PGSt_integer version = 1;
  char fullname [PGSd_PC_FILE_PATH_MAX];
  char extracted [PGSd_PC_FILE_PATH_MAX];
  if (PGS_PC_GetReference (filelogical, &version, fullname) != PGS_S_SUCCESS)
    diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_METADATA_MODULE, RETRIEVE_WARNING, filelogical, 0, 0,
                                 0, 0, 0, 0, 0, "Could not get filename");
  else {
    char* sptr = extracted;
    ExtractVersion (fullname, extracted);
    if (attribute_group::Set (handle, "PGEVersion", (void*) &sptr))
      isset = true;
  }

  return isset;
}
