/********** OrbitCalculatedSpatialDomain.h ****************************************************************************\

 $Header$

 REVISION HISTORY
   06/99  Tom Lauren
   08/99  Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_ORBIT_CALCULATED_SPATIAL_DOMAIN_

  #define _MOPITT_L1_ORBIT_CALCULATED_SPATIAL_DOMAIN_

  #include "PGS_MET.h"
  #include "AttributeGroup.h"
  #include "DateTimeGroup.h"
  #include "MOPITTTime.h"

  class orbit_calculated_spatial_domain : public attribute_group, public date_time_group {
    private:
      static int const    EPHEMERIS_WARNING;
      static double const RADS_TO_DEGREES;
      static int const    ORBITAL_MODEL_NAME_SIZE = 80;

      char   orbitalmodelname [ORBITAL_MODEL_NAME_SIZE];
      int    startorbitnumber;
      char   equatorcrossingdate [DATE_SIZE];
      char   equatorcrossingtime [TIME_SIZE];
      int    orbitnumber;
      double equatorcrossinglongitude;
      int    stoporbitnumber;

      bool GetOrbitInfo (string const&, PGSt_integer&, PGSt_double&, string&);

    protected:

    public:
      orbit_calculated_spatial_domain ();
      ~orbit_calculated_spatial_domain ();

      bool Set (PGSt_MET_handle, mopitt_time const&, mopitt_time const&);
  };
 
#endif
