/********** OrbitCalculatedSpatialDomain.C ****************************************************************************\

 $Header$

 REVISION HISTORY
   06/99  Tom Lauren
   08/99  Charles Cavanaugh
   09/99  Charles Cavanaugh
   04/00  Charles Cavanaugh
   10/00  Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "PGS_EPH.h"
#include "OrbitCalculatedSpatialDomain.h"
#include "DiagnosticReporter.h"

extern diagnostic_reporter diagnosticreporter;

int const    orbit_calculated_spatial_domain::EPHEMERIS_WARNING  = 804;
double const orbit_calculated_spatial_domain::RADS_TO_DEGREES    = 57.2957795131;

orbit_calculated_spatial_domain :: orbit_calculated_spatial_domain ()
                                 : attribute_group (),
                                   date_time_group ()
{
  orbitalmodelname    [0] = '\0';
  equatorcrossingdate [0] = '\0';
  equatorcrossingtime [0] = '\0';
}


orbit_calculated_spatial_domain :: ~orbit_calculated_spatial_domain ()
{
  ;
}


static int const UTC_SIZE = 28;

bool orbit_calculated_spatial_domain :: GetOrbitInfo (string const& utctime, PGSt_integer& orbits, 
                                                      PGSt_double& downlons, string& descends)
{
  bool isretrieved = false;

  PGSt_double newdownlons [1];
  PGSt_double offsets [1] = {0.0};
  PGSt_integer neworbits [1], numorbits;
  char newascends [1] [UTC_SIZE], newdescends [1] [UTC_SIZE];

  if (PGS_EPH_GetEphMet (PGSd_EOS_AM, 1, (char*) utctime.c_str (), offsets, &numorbits, neworbits, newascends, 
                         newdescends, newdownlons) != PGS_S_SUCCESS) {
    string message = "Could not get orbit metadata for time ";
    message += utctime;
    diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_METADATA_MODULE, EPHEMERIS_WARNING, 0, 0, 0, 0, 0, 0,
                                 0, 0, message);
  }
  else {
    orbits = neworbits [0];
    downlons = newdownlons [0];
    descends = newdescends [0];
    isretrieved = true;
  }

  return isretrieved;
}


bool orbit_calculated_spatial_domain :: Set (PGSt_MET_handle handle, mopitt_time const& starttime,
                                             mopitt_time const& stoptime)
{
  bool isset = false;

  PGSt_double downlons;
  PGSt_integer orbits;
  string descends;

  // set the orbital model name
  strcpy (orbitalmodelname, "Unknown");

  // get info about the orbit corresponding to the start time
  mopitt_time firstorbit (starttime.GetTAI () + 13.05);
  GetOrbitInfo (firstorbit.GetUTC (), orbits, downlons, descends);
  startorbitnumber = orbits;
  orbitnumber = orbits;
  GetDate (descends, equatorcrossingdate);
  GetTime (descends, equatorcrossingtime);
  equatorcrossinglongitude = downlons * RADS_TO_DEGREES;

  // get info about the orbit corresponding to the stop time
  mopitt_time lastorbit (stoptime.GetTAI () - 13.05);
  GetOrbitInfo (lastorbit.GetUTC (), orbits, downlons, descends);
  stoporbitnumber = orbits;

  // sptr is necessary for some bizarre toolkit reason.
  char* sptr;

  sptr = orbitalmodelname;
  if (attribute_group::Set (handle, "OrbitalModelName.1", (void*) &sptr))
    if (attribute_group::Set (handle, "StartOrbitNumber.1", (void*) &startorbitnumber)) {
      sptr = equatorcrossingdate;
      if (attribute_group::Set (handle, "EquatorCrossingDate.1", (void*) &sptr)) {
        sptr = equatorcrossingtime;
        if (attribute_group::Set (handle, "EquatorCrossingTime.1", (void*) &sptr))
          if (attribute_group::Set (handle, "OrbitNumber.1", (void*) &orbitnumber))
            if (attribute_group::Set (handle, "EquatorCrossingLongitude.1", (void*) &equatorcrossinglongitude))
              if (attribute_group::Set (handle, "StopOrbitNumber.1", (void*) &stoporbitnumber))
                isset = true;
      }
    }

  return isset;
}
