/********** MeasuredParameter.C ***************************************************************************************\

 $Header$

 REVISION HISTORY
   06/99  Tom Lauren
   08/99  Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "MeasuredParameter.h"

measured_parameter :: measured_parameter ()
                    : attribute_group ()
{
  parametername [0] = '\0';
}


measured_parameter :: ~measured_parameter ()
{
  ;
}


bool measured_parameter :: Set (PGSt_MET_handle handle, string const& name, int parameternumber, int missing, 
                                int outofbounds, int interpolated)
{
  bool isset = false;

  // save the measured parameter name
  (void) strcpy (parametername, name.c_str ());

  // store the value
  char attributename [20];
  (void) sprintf (attributename, "ParameterName.%d", parameternumber);
  char *sptr = parametername;

  // set the attribute name, qa flags and qa stats
  if (attribute_group::Set (handle, attributename, (void*) &sptr))
    if (qaflags.Set (handle, parameternumber))
      if (qastats.Set (handle, parameternumber, missing, outofbounds, interpolated))
        isset = true;

  return isset;
}
