/********** InputGranule.C ********************************************************************************************\

 $Header$

 REVISION HISTORY
   06/99  Tom Lauren
   08/99  Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include <stdarg.h>
#include "InputGranule.h"

input_granule :: input_granule ()
               : attribute_group ()
{
  inputpointer = NULL;
}


input_granule :: ~input_granule ()
{
  ;
}


void input_granule :: ExtractFileName (char fullname [], char extracted []) const
{
  // save the full name (so it wont get mangled)
  char newfullname [PGSd_PC_FILE_PATH_MAX];
  (void) strcpy (newfullname, fullname);

  // recover the filename by parsing the full name with '/' as a token delimiter
  char* token = strtok (newfullname, "/");
  (void) strcpy (extracted, token);
  while ((token = strtok (NULL, "/")) != NULL) {
    (void) strcpy (extracted, token);
  }
}


void input_granule :: ExtractShortName (char fullname [], char extracted []) const
{
  // extract the file name
  char filename [PGSd_PC_FILE_PATH_MAX];
  ExtractFileName (fullname, filename);

  // extract the short name
  char* token = strtok (filename, "-_");
  (void) strcpy (extracted, token);
}


bool input_granule :: Set (PGSt_MET_handle handle, int idcount, PGSt_PC_Logical logical1, ...)
{
  bool isset = false;
  char physical_filename[PGSd_PC_FILE_PATH_MAX];

  // make room for the input pointers
  inputpointer = new input_pointer [idcount + 1];

  // make room for pointers to the input pointers
  char** inputpointerpointers = new char* [idcount + 1];

  // start access to the variable argument list
  va_list argptr;
  va_start (argptr, idcount);

  // loop over the number of logicals
  PGSt_PC_Logical logical;
  PGSt_integer sequence;
  PGSt_integer version;
  PGSt_SMF_status readstatus;
  bool keeplooking;
  input_pointer urtemp;
  int storedcount = 0;
  for (int logicalcount = 0; logicalcount < idcount; logicalcount++) {

    // retrieve the next logical
    logical = (PGSt_PC_Logical) va_arg (argptr, PGSt_PC_Logical);

    // get the ur for the file that's last in sequence
    version = 1;
    sequence = 1;
    keeplooking = true;
    while (keeplooking) {
      if ((readstatus = PGS_PC_GetUniversalRef (logical, &sequence, (char*) urtemp)) != PGS_S_SUCCESS)
        keeplooking = false;
      else if (sequence == 0)
        keeplooking = false;
      else {
        version++;
        sequence = version;
      }
    }
      
    // store the value in the list of input pointers
    if (readstatus == PGS_S_SUCCESS) {
      (void) strcpy (inputpointer [storedcount], urtemp);
      storedcount++;
    }
    else {
      version = 1;
      if ((PGS_PC_GetReference (logical, &version, physical_filename )) == PGS_S_SUCCESS) {
	(void) strcpy (inputpointer [storedcount], physical_filename );
	storedcount++;
      }
    }
  }

  // end access to the argument list
  va_end (argptr);

  // the last input pointer must always be NULL
  (void) strcpy (inputpointer [storedcount], "\0");

  // set the pointer pointers to the pointers
  for (int pointernumber = 0; pointernumber <= storedcount; pointernumber++)
    inputpointerpointers [pointernumber] = (char*) inputpointer [pointernumber];

  // store the values
  isset = attribute_group::Set (handle, "InputPointer", (void*) inputpointerpointers);
  
  // delete the memory used
  delete [] inputpointer;
  delete [] inputpointerpointers;

  // return the status
  return isset;
}
