/********** HDFMetadata.C *********************************************************************************************\

 $Header$

 REVISION HISTORY
   06/99  Tom Lauren
   08/99  Charles Cavanaugh
   09/99  Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "HDFMetadata.h"
#include "DiagnosticReporter.h"
#include <PGS_SMF.h>

extern diagnostic_reporter diagnosticreporter;

int const hdf_metadata::WRITE_ERROR = 903;

hdf_metadata :: hdf_metadata ()
              : general_metadata ()
{
  ;
}


hdf_metadata :: hdf_metadata (PGSt_PC_Logical filelogical)
              : general_metadata (filelogical)
{
  ;
}


hdf_metadata :: ~hdf_metadata ()
{
  ;
}


bool hdf_metadata :: Write (int32 metadataid)
{
  bool iswritten = false;
  PGSt_SMF_status status;
  char msg[PGS_SMF_MAX_MSG_SIZE];
  char err[PGS_SMF_MAX_MNEMONIC_SIZE];

  // proceed only if metadata mechanism has been initialized
  if (IsInitialized ()) {
  
    // write the metadata to the hdf file and the ascii file
    status = PGS_MET_Write (handles [INVENTORYMETADATA], (char*) "coremetadata.0", (PGSt_integer) metadataid);
    if (status == PGS_S_SUCCESS)
      iswritten = true;
    else {
      PGS_SMF_GetMsg(&status, err, msg);
      diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_METADATA_MODULE, WRITE_ERROR, 0, 0, 0, 0, 0, 0, 0, 0,
				   msg);
    }
  }
  return iswritten;
}
