/********** GeneralMetadata.C ****************************************************************************************\

 $Header$

 REVISION HISTORY
   06/99  Tom Lauren
   08/99  Charles Cavanaugh
   09/99  Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "GeneralMetadata.h"
#include "DiagnosticReporter.h"
#include <PGS_SMF.h>

int const general_metadata::INIT_ERROR   = 900;
int const general_metadata::INIT_WARNING = 800;

extern diagnostic_reporter diagnosticreporter;

general_metadata :: general_metadata ()
{
  isinitialized = false;
  logical = 0;
}


general_metadata :: general_metadata (PGSt_PC_Logical filelogical)
{
  isinitialized = false;
  logical = filelogical;
}


general_metadata :: ~general_metadata ()
{
  Finalize ();
}


bool general_metadata :: Finalize () const
{
  bool isfinalized = false;

  // proceed only if metadata mechanism has been initialized
  if (isinitialized) {
    PGS_MET_Remove ();
    isfinalized = true;
  }

  return isfinalized;
}


bool general_metadata :: Initialize ()
{
  bool isinit = false;
  PGSt_SMF_status status;
  char msg[PGS_SMF_MAX_MSG_SIZE];
  char err[PGS_SMF_MAX_MNEMONIC_SIZE];

  // make sure metadata has not already been initialized
  if (isinitialized)
    diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_METADATA_MODULE, INIT_WARNING, 0, 0, 0, 0, 0, 
                                 0, 0, 0, "Could not initialize initialized metadata");

  // make sure logical is not invalid
  else if (logical == 0)
    diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_METADATA_MODULE, INIT_WARNING, 0, 0, 0, 0, 0, 0, 0, 0,
				 "Could not initialize metadata without a logical");

    // make sure metadata initialization did not fail
  else {
    status = PGS_MET_Init (logical, handles);
    if ( status != PGS_S_SUCCESS) {
      PGS_SMF_GetMsg(&status, err, msg);
      diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_METADATA_MODULE, INIT_ERROR, 0, 0, 0, 0, 0,
				   0, 0, 0, msg);
      diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_METADATA_MODULE, INIT_ERROR, 0, 0, 0, 0, 0,
				   0, 0, 0, "Could not initialize metadata");
    }
    // make sure initialization flags are set
    else {
      isinit = true;
      isinitialized = true;
    }
  }
  
  return isinit;
}


bool general_metadata :: Initialize (PGSt_PC_Logical filelogical)
{
  bool isinit = false;
  PGSt_SMF_status status;
  char msg[PGS_SMF_MAX_MSG_SIZE];
  char err[PGS_SMF_MAX_MNEMONIC_SIZE];

  // make sure metadata has not already been initialized
  if (isinitialized)
    diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_METADATA_MODULE, INIT_WARNING, 0, 0, 0, 0, 0,
                                 0, 0, 0, "Could not initialize initialized metadata");
  else {

    // set the logical and make sure metadata initialization did not fail
    logical = filelogical;
    status = PGS_MET_Init (logical, handles);
    if (status != PGS_S_SUCCESS){
      PGS_SMF_GetMsg(&status, err, msg);
      diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_METADATA_MODULE, INIT_ERROR, 0, 0, 0, 0, 0,
				   0, 0, 0, msg);
      diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_METADATA_MODULE, INIT_ERROR, 0, 0, 0, 0, 0,
                                   0, 0, 0, "Could not initialize metadata");
    }

    // make sure initialization flags are set
    else {
      isinit = true;
      isinitialized = true;
    }
  }

  return isinit;
}
