/********** ECSDataGranule.C ******************************************************************************************\

 $Header$

 REVISION HISTORY
   06/99  Tom Lauren
   08/99  Charles Cavanaugh
   06/00  Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include <string.h>
#include "ECSDataGranule.h"
#include "DiagnosticReporter.h"

extern diagnostic_reporter diagnosticreporter;

ecs_data_granule :: ecs_data_granule ()
                  : attribute_group ()
{
  localgranuleid [0] = '\0';
  localversionid [0] = '\0';
}


ecs_data_granule :: ~ecs_data_granule ()
{
  ;
}


void ecs_data_granule :: ExtractFileName (char fullname [], char extracted []) const
{
  // save the full name (so it wont get mangled)
  char newfullname [PGSd_PC_FILE_PATH_MAX];
  (void) strcpy (newfullname, fullname);

  // recover the filename by parsing the full name with '/' as a token delimiter
  char* token = strtok (newfullname, "/");
  (void) strcpy (extracted, token);
  while ((token = strtok (NULL, "/")) != NULL) {
    (void) strcpy (extracted, token);
  }
}


void ecs_data_granule :: ExtractVersion (char fullname [], char extracted []) const
{
  // extract the file name
  char filename [PGSd_PC_FILE_PATH_MAX];
  ExtractFileName (fullname, filename);

  // extract the version info
  char* version = strstr (filename, "L1V");
  char* token = strtok (version, "V");
  token = strtok (NULL, "");
  (void) strncpy (extracted, token, strlen (token) - 4);
  extracted [strlen (token) - 4] = '\0';
}


bool ecs_data_granule :: Set (PGSt_MET_handle handle, PGSt_PC_Logical filelogical)
{
  bool isset = false;

  // get the full filename from the filelogical
  PGSt_integer version = 1;
  char fullname [PGSd_PC_FILE_PATH_MAX];
  char extracted [PGSd_PC_FILE_PATH_MAX];
  if (PGS_PC_GetReference (filelogical, &version, fullname) != PGS_S_SUCCESS)
    diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_METADATA_MODULE, RETRIEVE_WARNING, filelogical, 0, 0,
                                 0, 0, 0, 0, 0, "Could not get filename");
  else {

    // sptr is necessary for some bizarre toolkit reason.
    char* sptr = extracted;

    // extract the filename from the full name and store the filename
    ExtractFileName (fullname, extracted);
    if (attribute_group::Set (handle, "LocalGranuleID", (void*) &sptr)) {

      // extract the version from the full name and store the version
      ExtractVersion (fullname, extracted);
      if (attribute_group::Set (handle, "LocalVersionID", (void*) &sptr))
        isset = true;
    }
  }

  return isset;
}
