/********** AttributeGroup.C ******************************************************************************************\

 $Header$

 REVISION HISTORY
   06/99  Tom Lauren
   08/99  Charles Cavanaugh
   09/99  Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "AttributeGroup.h"
#include "MetadataConstants.h"
#include "DiagnosticReporter.h"

extern diagnostic_reporter diagnosticreporter;

int const attribute_group::SET_ERROR        = 901;
int const attribute_group::RETRIEVE_WARNING = 802;

attribute_group :: attribute_group ()
{
  ;
}


attribute_group :: ~attribute_group ()
{
  ;
}


bool attribute_group :: Set (PGSt_MET_handle handle, string const& attrname, void const* const attrval)
{
  bool isset = true;

  // set the attribute
  if (PGS_MET_SetAttr (handle, (char*) attrname.c_str (), (void*) attrval) != PGS_S_SUCCESS) {
    isset = false;
    string message = "Could not set metadata attribute ";
    message += attrname;
    diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_METADATA_MODULE, SET_ERROR, 0, 0, 0, 0, 0, 0, 0, 0,
                                 message);
  }

  return isset;
}
