/********** ASCIIMetadata.C *******************************************************************************************\

 $Header$

 REVISION HISTORY
   06/99  Tom Lauren
   08/99  Charles Cavanaugh
   09/99  Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "ASCIIMetadata.h"
#include "DiagnosticReporter.h"

extern diagnostic_reporter diagnosticreporter;

int const ascii_metadata::WRITE_ERROR = 902;

ascii_metadata :: ascii_metadata () 
                : general_metadata ()
{
  ;
}


ascii_metadata :: ascii_metadata (PGSt_PC_Logical filelogical)
                : general_metadata (filelogical)
{
  ;
}


ascii_metadata :: ~ascii_metadata ()
{
  ;
}


bool ascii_metadata :: Write (PGSt_PC_Logical metadatalogical)
{
  bool iswritten = false;

  // proceed only if metadata mechanism has been initialized
  if (IsInitialized ()) {

    // write the metadata to the file described by the logical
    if (PGS_MET_Write (handles [ODL_IN_MEMORY], NULL, metadatalogical) == PGS_S_SUCCESS) 
      iswritten = true;
    else
      diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_METADATA_MODULE, WRITE_ERROR, metadatalogical, 0, 0, 
                                   0, 0, 0, 0, 0, "Could not write metadata to ASCII file");
  }

  return iswritten;
}
