/********** L0Packet.h ************************************************************************************************\

 $Header$

 REVISION HISTORY
   12/98   Charles Cavanaugh
   09/00   Daniel Ziskin

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_L0_PACKET_

  #define _MOPITT_L1_L0_PACKET_

  #include "PGS_IO.h"
  #include "MOPITTTime.h"

  int const CCSDS_HEADER_LENGTH = 16;

  class l0_packet {
    private :
      static int const PACKET_APID_START;
      static int const PACKET_SEQUENCE_START;
      static int const PACKET_LENGTH_START;
      static int const PACKET_TIME_START;
      static int const SEQUENCE_GAP;

      bool Set (PGSt_IO_L0_Packet*);

    protected :
      static int const PACKET_APPLICATION_DATA_START;

      PGSt_IO_L0_Packet* data;
      int                apid;
      int                sequence;
      int                length;
      mopitt_time        time;

    public :
      l0_packet ();
      l0_packet (PGSt_IO_L0_Packet*);
      virtual ~l0_packet () = 0;

      int         GetAPID                () const {return apid;}
      int         GetLength              () const {return length;}
      int         GetSequence            () const {return sequence;}
      int         GetSequenceErrCode     () const {return SEQUENCE_GAP;}
      mopitt_time GetTime                () const {return time;}
      string      MakeWrongAPIDMessage   () const;
      string      MakeWrongLengthMessage () const;
      string      MakeSequenceGapMessage (int, int) const;
      bool        SequenceGap            (int, int) const;
  };

#endif






