/********** L0Packet.C ************************************************************************************************\

 $Header$

 REVISION HISTORY
   12/98   Charles Cavanaugh
   09/00   Daniel Ziskin

 $Log$

\**********************************************************************************************************************/

#include "L0Packet.h"

int const l0_packet::PACKET_APID_START             = 0;
int const l0_packet::PACKET_SEQUENCE_START         = 2;
int const l0_packet::PACKET_LENGTH_START           = 4;
int const l0_packet::PACKET_TIME_START             = 6;
int const l0_packet::PACKET_APPLICATION_DATA_START = CCSDS_HEADER_LENGTH;
int const l0_packet::SEQUENCE_GAP                  = 904;



l0_packet :: l0_packet ()
           : time ()
{
  data = NULL;
  apid = 0;
  sequence = 0;
  length = 0;
}


l0_packet :: l0_packet (PGSt_IO_L0_Packet* packetdata)
{
  Set (packetdata);
}


l0_packet :: ~l0_packet ()
{
  delete [] data;
}


bool l0_packet :: Set (PGSt_IO_L0_Packet* packetdata)
{
  // manage the data pointer
  data = packetdata;

  // compute the packet apid
  apid = ((data[PACKET_APID_START] & 0x07) * 256) + (int) data[PACKET_APID_START + 1];

  // compute the packet sequence counter
  sequence = ((data[PACKET_SEQUENCE_START] & 0x3F) * 256) + (int) data[PACKET_SEQUENCE_START + 1];

  // compute the packet length (of just the application data)
  length = ((data[PACKET_LENGTH_START] * 256) + (int) data[PACKET_LENGTH_START + 1]) - 9;

  // compute the packet time
  int packetday = ((data[PACKET_TIME_START + 0] & 0x7F) * 256) + (int) data[PACKET_TIME_START + 1];
  int packettime = (data[PACKET_TIME_START + 2] * 16777216) + (data[PACKET_TIME_START + 3] * 65536) + 
                   (data[PACKET_TIME_START + 4] * 256) + (int) data[PACKET_TIME_START + 5];
  return time.Set (packetday, packettime);
}


string l0_packet :: MakeWrongAPIDMessage () const
{
  char idchars [10];
  (void) sprintf (idchars, "%d", apid);
  string message = "A science packet has the wrong apid :";
  message += idchars;

  return message;
}


string l0_packet :: MakeWrongLengthMessage () const
{
  char idchars [10];
  (void) sprintf (idchars, "%d", length);
  string message = "A science packet has an atypical length : ";
  message += idchars;

  return message;
}


string l0_packet :: MakeSequenceGapMessage (int seq1, int seq2) const
{
  char seq1char [10], seq2char [10];
  (void) sprintf (seq1char, "%d", seq1);
  (void) sprintf (seq2char, "%d", seq2);
  string message = "Sequence Gap - Previous and Current: ";
  message += seq1char;
  message += " ";
  message += seq2char;

  return message;
}


bool l0_packet :: SequenceGap (int seq1, int seq2) const
{
  bool gap;

  (seq2 - seq1) == 1 ? gap = false : gap = true;
  
  return gap;
}
