/********** L0File.C **************************************************************************************************\

 $Header$

 REVISION HISTORY
   12/98   Charles Cavanaugh
   09/99   Charles Cavanaugh
   10/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "L0File.h"
#include "DiagnosticReporter.h"

int const l0_file::RETRIEVE_ERROR = 903;
int const l0_file::OPEN_WARNING   = 801;
int const l0_file::CLOSE_WARNING  = 802;

int const PACKET_TIME_START       = 6;

extern diagnostic_reporter diagnosticreporter;


l0_file :: l0_file ()
         : processor_file ()
{
  isopen = false;
  packetsize = 0;
}


l0_file :: l0_file (PGSt_PC_Logical filelogical, int filepacketsize)
         : processor_file (filelogical)
{
  isopen = false;
  packetsize = filepacketsize;
}


l0_file :: ~l0_file ()
{
  Close ();
}


bool l0_file :: Close ()
{
  bool isclosed = true;

  // if the file is open, close it
  if (isopen) {
    isopen = false;
    if (PGS_IO_L0_Close (id) != PGS_S_SUCCESS) {
      isclosed = false;
      diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_L0_MODULE, CLOSE_WARNING, GetLogical (), 0, 0, 0, 
                                   0, 0, 0, 0, "Could not close L0 file");
    }
  }

  return isclosed;
}


bool l0_file :: GetPacket (PGSt_IO_L0_Packet* data)
{
  bool gotpacket = false;
  PGSt_SMF_status packstat;

  // check for file open
  if (isopen) {

    // read the next packet and set status flag
    packstat = PGS_IO_L0_GetPacket (id, packetsize, data);
    if (packstat == PGS_S_SUCCESS || packstat == PGSIO_W_L0_END_OF_VIRTUAL_DS || packstat == PGSIO_M_L0_HEADER_CHANGED) {
      gotpacket = true;

      // check the packet time
      mopitt_time time;
      int packetday = ((data[PACKET_TIME_START + 0] & 0x7F) * 256) + (int) data[PACKET_TIME_START + 1];
      int packettime = (data[PACKET_TIME_START + 2] * 16777216) + (data[PACKET_TIME_START + 3] * 65536) + 
	               (data[PACKET_TIME_START + 4] * 256) + (int) data[PACKET_TIME_START + 5];
      gotpacket = time.Set (packetday, packettime);
    }
  }

  return gotpacket;
}


bool l0_file :: Open ()
{
  if (! isopen && packetsize > 0) {

    if (Initialize ()) {

      // call the toolkit routine to open the L0 virtual file
      PGSt_double starttime, stoptime;
      if (PGS_IO_L0_Open (GetLogical (), PGSd_EOS_AM, &id, &starttime, &stoptime) == PGS_S_SUCCESS)
        isopen = true;
      else
        diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_L0_MODULE, OPEN_WARNING, GetLogical (), 0, 0, 0, 
                                     0, 0, 0, 0, "Could not open L0 file");
    } 
  } 

  return isopen;
}
