/********** L0Collection.C ********************************************************************************************\

 $Header$

 REVISION HISTORY
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "L0Collection.h"
#include "DiagnosticReporter.h"

int const l0_collection::INIT_WARNING = 800;

extern diagnostic_reporter diagnosticreporter;

l0_collection :: l0_collection ()
{
  packetsize = 0;
  l0file = NULL;
}


l0_collection :: l0_collection (PGSt_PC_Logical filelogical, int filepacketsize)
{
  l0file = NULL;
  packetsize = filepacketsize;
  Initialize (filelogical, filepacketsize);
}


l0_collection :: ~l0_collection ()
{
  delete l0file;
}


bool l0_collection :: GetPacket (PGSt_IO_L0_Packet* data)
{
  bool gotpacket = false;

  // while the l0 file is active and a packet has not been retrieved
  while (l0file != NULL && ! gotpacket) {

    // get a packet
    if (l0file->GetPacket (data))
      gotpacket = true;
    else {

      // inactivate current file (first retrieving the file's logical)
      int logical = 1 + l0file->GetLogical ();
      delete l0file;
      l0file = NULL;

      // activate new file
      Initialize (logical, packetsize);
    }
  } 

  return gotpacket;
}


bool l0_collection :: Initialize (PGSt_PC_Logical filelogical, int filepacketsize)
{
  bool isinitialized = false;

  // proceed only if initialization has not been done
  if (l0file != NULL)
    diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_L0_MODULE, INIT_WARNING, filelogical, 0, 0, 0, 0, 0, 
                                 0, 0, "Could not initialize already initialized l0 collection");
  else {

    // initialize the l0 file pointer
    l0file = new l0_file (filelogical, filepacketsize);
    if (l0file->Open ()) 
      isinitialized = true;
    else {
      delete l0file;
      l0file = NULL;
    }
  }

  return isinitialized;
}
