/********** HDFVGroup.C ***********************************************************************************************\

 $Header$

 REVISION HISTORY
   09/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "vg.h"
#include "HDFVGroup.h"
#include "DiagnosticReporter.h"

int const hdf_vgroup::ATTACH_ERROR = 900;
int const hdf_vgroup::CLOSE_ERROR  = 901;
int const hdf_vgroup::CREATE_ERROR = 902;
int const hdf_vgroup::INSERT_ERROR = 903;

extern diagnostic_reporter diagnosticreporter;

hdf_vgroup :: hdf_vgroup ()
{
  id = 0;
}


hdf_vgroup :: ~hdf_vgroup ()
{
  ;
}


bool hdf_vgroup :: Attach (int32 fileid, string const& groupname)
{
  bool isattached = false;

  // find the groupname in the file and then attach to the group
  int32 refindex;
  if ((refindex = Vfind (fileid, (char*) groupname.c_str ())) > 0)
    if ((id = Vattach (fileid, refindex, "r")) != FAIL)
      isattached = true;

  if (! isattached) {
    id = 0;
    string message = "Could not attach to an hdf vgroup with name ";
    message += groupname;
    diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_HDF_MODULE, ATTACH_ERROR, 0, 0, 0, 0, 0, 0, 0, 0,
                                 message);
  }

  return isattached;
}


bool hdf_vgroup :: Close ()
{
  bool isclosed = true;

  // detach from the vgroup
  if (Vdetach (id) == FAIL) {
    char idchars [10];
    (void) sprintf (idchars, "%d", id);
    string message = "Could not close an hdf vgroup with id ";
    message += idchars;
    diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_HDF_MODULE, CLOSE_ERROR, 0, 0, 0, 0, 0, 0, 0, 0,
                                 message);
    isclosed = false;
  }

  return isclosed;
}


bool hdf_vgroup :: Create (string const& groupname, string const& groupclass, int32 fileid)
{
  bool iscreated = false;

  // create the vgroup and set the name and class
  if ((id = Vattach (fileid, -1, "w")) != FAIL)
    if (Vsetname (id, (char*) groupname.c_str ()) != FAIL)
      if (Vsetclass (id, (char*) groupclass.c_str ()) != FAIL)
        iscreated = true;

  if (! iscreated) {
    string message = "Could not create the hdf vgroup ";
    message += groupname;
    diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_HDF_MODULE, CREATE_ERROR, 0, 0, 0, 0, 0, 0, 0, 0,
                                 message);
  }

  return iscreated;
}


bool hdf_vgroup :: Insert (int32 fileid)
{
  bool isinserted = true;

  // insert the vgroup into the file
  if (Vinsert (fileid, id) == FAIL) {
    diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_HDF_MODULE, INSERT_ERROR, 0, 0, 0, 0, 0, 0, 0, 0,
                                 "Could not insert the hdf vgroup into the file");
    isinserted = false;
  }

  return isinserted;
}
