/********** HDFVData.h ************************************************************************************************\

 $Header$

 REVISION HISTORY
   09/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_HDF_VDATA_

  #define _MOPITT_L1_HDF_VDATA_

  #include <string>
  #include "mfhdf.h"

  using namespace std;

  class hdf_vdata {
    private :
      static int const ATTACH_ERROR;
      static int const CLOSE_ERROR;
      static int const CREATE_ERROR;
      static int const DEFINE_ERROR;
      static int const READ_ERROR;
      static int const SET_ERROR;
      static int const INSERT_ERROR;
      static int const WRITE_ERROR;

      bool  ishetero;
      int32 fields;
      int32 bytecount;
      int32 records;
      int32 id;

      void CheckHeterogeneity (int, int32 const []);
      int  HDFSizeOf (int32);

    protected :

    public :
      hdf_vdata ();
      ~hdf_vdata ();

      bool Attach   (int32, string const&, string const&);
      bool Attach   (int32, string const&, string const []);
      bool Close    ();
      bool Create   (string const&, string const&, int32);
      bool Define   (int32, int, const char* const, ...);
      bool Define   (int, int32 const [], int32 const [], string const []);
      int  GetCount () const {return (int) records;}
      bool Insert   (int32);
      bool Read     (int32, void* []);
      bool Set      (string const&);
      bool Set      (int, string const []);
      bool Write    (void*);
      bool Write    (void* []);
  };

#endif
