/********** HDFSwathGroup.C *******************************************************************************************\

 $Header$

 REVISION HISTORY
   09/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "HDFSwathGroup.h"
#include "SwathConstants.h"
#include "DiagnosticReporter.h"
#include <string>
#include <iostream>

int const hdf_swath_group::ATTACH_ERROR = 901;
int const hdf_swath_group::CLOSE_ERROR  = 902;
int const hdf_swath_group::CREATE_ERROR = 903;

extern diagnostic_reporter diagnosticreporter;

hdf_swath_group :: hdf_swath_group ()
                 : name ()
{
  id = 0;
}


hdf_swath_group :: ~hdf_swath_group ()
{
  ;
}


bool hdf_swath_group :: Attach (string const& groupname, hid_t fileid)
{
  bool isattached = true;

  // create the vgroup and set the name and class
  name = groupname;
  if ((id = HE5_SWattach (fileid, (char*) groupname.c_str ())) == FAIL) {
    isattached = false;
    string message = "Could not attach to the hdf swath group ";
    message += name;
    diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_HDF_MODULE, ATTACH_ERROR, 0, 0, 0, 0, 0, 0, 0, 0,
                                 message);
  }

  return isattached;
}


bool hdf_swath_group :: Close ()
{
  bool isclosed = true;

  // detach from the swath group
  if (HE5_SWdetach (id) == FAIL) {
    string message = "Could not close hdf swath group ";
    message += name;
    diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_HDF_MODULE, CLOSE_ERROR, 0, 0, 0, 0, 0, 0, 0, 0,
                                 message);
    isclosed = false;
  }

  return isclosed;
}


bool hdf_swath_group :: Create (string const& groupname, hid_t fileid)
{
  bool iscreated = true;

  int dnum = 11;
  hsize_t dsizes [11] = { DIM_TMP_TRACK, DIM_STARES, DIM_PIXELS, DIM_CHANNELS, DIM_RADIANCE_STATES, 
                          DIM_ENGINEERING_TERMS, DIM_ENGINEERING_STATES, DIM_LMC_SECTORS, 
                          DIM_CALIBRATION_TERMS, DIM_PMC_CHANNELS, DIM_PACKETPOSITION };
  string dnames [11] = { "ntrack", "nstare", "npixels", "nchan", "nstate", "nengpoints", "neng", "nsector", 
			 "ncalib", "npchan", "nposition"};

  // create the vgroup and set the name and class
  name = groupname;
  if ((id = HE5_SWcreate (fileid, (char*) groupname.c_str ())) == FAIL) {
    iscreated = false;
    string message = "Could not make the hdf swath group ";
    message += name;
    diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_HDF_MODULE, CREATE_ERROR, 0, 0, 0, 0, 0, 0, 0, 0,
                                 message);
  }

  if (HE5_SWdefdim (id, "Unlim", H5S_UNLIMITED) == FAIL) {
    iscreated = false;
    string message = "Could not define Unlim";
    diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_HDF_MODULE, CREATE_ERROR, 0, 0, 0, 0, 0, 0, 0, 0, 
				 message);
  }

  for (int i = 0; i < dnum; i++) {
    if (HE5_SWdefdim (id, (char*) (dnames [i]). c_str (), dsizes [i]) == FAIL) {
      iscreated = false;
      string message = "Could not define ";
      message += name.c_str ();
      message += " dimension ";
      message += dnames [i];
      diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_HDF_MODULE, CREATE_ERROR, 0, 0, 0, 0, 0, 0, 0, 0, 
                                   message);
    }
    //cout << i<< dnames [i].c_str () << dsizes [i] << endl;
  }

  return iscreated;
}


bool hdf_swath_group :: defDS ( )
{
  bool isdefined = true;

  int dnum = 10;
  hsize_t dsizes [10] = { DIM_STARES, DIM_PIXELS, DIM_CHANNELS, DIM_RADIANCE_STATES, 
                          DIM_ENGINEERING_TERMS, DIM_ENGINEERING_STATES, DIM_LMC_SECTORS, 
                          DIM_CALIBRATION_TERMS, DIM_PMC_CHANNELS, DIM_PACKETPOSITION };
  string dnames [10] = { "nstare", "npixels", "nchan", "nstate", "nengpoints", "neng", "nsector", 
			 "ncalib", "npchan", "nposition"};

  for (int i = 0; i < dnum; i++) {
    
    int asize = dsizes[i];
    int ddata[asize];
    for (int j = 0; j < asize; j++) {
      ddata[j] = j + 1;
    }
    diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_HDF_MODULE, CREATE_ERROR, asize, 0, 0, 0, 0, 0, 0, 0, 
				 dnames[i].c_str() );
    
    if (HE5_SWdefdimscale (id, (char*)(dnames[i]). c_str (), dsizes[i], H5T_NATIVE_INT, ddata) == FAIL) {
      isdefined = false;
      string message = "Could not define dimension scale";
      message += name.c_str ();
      message += " dimension ";
      message += dnames [i];
      diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_HDF_MODULE, CREATE_ERROR, 0, 0, 0, 0, 0, 0, 0, 0, 
                                   message);
    }
  }

  return isdefined;
}


bool hdf_swath_group :: Reset (hid_t fileid)
{
  bool isreset = false;

  // close the group
  if (Close ())

    // attach to the group
    if (Attach (name.c_str (), fileid))
      isreset = true;

  return isreset;
}


bool hdf_swath_group :: WriteAttribute (string const& attributename, hid_t attributetype, VOIDP attribute)
{
  bool iswritten = false;
  hsize_t cnt = 1;

  // write the global attribute
  if (HE5_SWwriteattr (id, (char*) attributename.c_str (), attributetype, &cnt, attribute) != FAIL)
    iswritten = true;

  return iswritten;
}
