/********** HDFSwathGeolocationDataset.C ******************************************************************************\

 $Header$

 REVISION HISTORY
   11/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "HDFSwathGeolocationDataset.h"
#include "DiagnosticReporter.h"
#include "SwathConstants.h"

extern diagnostic_reporter diagnosticreporter;

int const hdf_swath_geolocation_dataset::CHUNK_ERROR = 920;

hdf_swath_geolocation_dataset :: hdf_swath_geolocation_dataset ()
                               : hdf_swath_dataset ()
{
  ;
}


hdf_swath_geolocation_dataset :: hdf_swath_geolocation_dataset (string const& datasetname, int32 datasettype, 
                                                                int datasetdimensions, 
                                                                hsize_t const datasetdimensionsizes [], 
                                                                string const datasetdimensionnames [])
                               : hdf_swath_dataset (datasetname, datasettype, datasetdimensions, datasetdimensionsizes, 
                                                    datasetdimensionnames)
{
  ;
}


hdf_swath_geolocation_dataset :: ~hdf_swath_geolocation_dataset ()
{
  ;
}


bool hdf_swath_geolocation_dataset :: SetField (hid_t dataid, string const& name, int const& ndim, hsize_t const sdims[],
						string const& dimnames, string const& maxdimnames, hid_t type)
{
  bool isset = false;

  int compparm[5];
  
  diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_HDF_MODULE, CHUNK_ERROR, 0, 0, 0, 0, 0, 0, 0, 0, 
			       name.c_str());
  diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_HDF_MODULE, CHUNK_ERROR, 0, 0, 0, 0, 0, 0, 0, 0, 
			       dimnames.c_str());
  diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_HDF_MODULE, CHUNK_ERROR, 0, 0, 0, 0, 0, 0, 0, 0, 
			       maxdimnames.c_str());

  // define chunk
  if ((HE5_SWdefchunk(dataid, ndim, sdims)) == FAIL) {
    string message = "Could not define chunk for ";
    message += name.c_str ();
    diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_HDF_MODULE, CHUNK_ERROR, 0, 0, 0, 0, 0, 0, 0, 0, 
				 message);
  }

  if (ndim > 1) {    
    // def comp
    compparm[0] = 5;
    if ((HE5_SWdefcomp(dataid, HE5_HDFE_COMP_DEFLATE, compparm)) == FAIL) {
      string message = "Could not define comp for ";
      message += name.c_str ();
      diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_HDF_MODULE, CHUNK_ERROR, 0, 0, 0, 0, 0, 0, 0, 0, 
				   message);
    }
  }
  
  // define the "geolocation" dataset
  if (HE5_SWdefgeofield (dataid, (char*) name.c_str (), (char*) dimnames.c_str (), (char*) maxdimnames.c_str (), 
			 type, HE5_HDFE_NOMERGE) == FAIL)
    diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_HDF_MODULE, CHUNK_ERROR, 0, 0, 0, 0, 0, 0, 0, 0, 
				 "HE5_SWdefgeofield Failed!");
  isset = true;

  return isset;
}
