/********** HDFSwathDataset.h *****************************************************************************************\

 $Header$

 REVISION HISTORY
   11/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_HDF_SWATH_DATASET_

  #define _MOPITT_L1_HDF_SWATH_DATASET_

  #include <string>
  #include "mfhdf.h"
  #include "HE5_HdfEosDef.h"

  using namespace std;

  class hdf_swath_dataset {
    private :
      static int const INITIALIZE_ERROR;
      static int const SET_ERROR;
      static int const WRITE_ERROR;

      string    name;
      hid_t     type;
      int       dimensions;
      hsize_t*  dimensionsizes;
      string*   dimensionnames;
      string*   maxdimensionnames;
      hssize_t* start;
      int       trackindex;

      bool Initialize (string const&, int32, int, hsize_t const [], string const []);
      //bool Set        (hid_t);

    protected : 
      virtual bool SetField (hid_t, string const&, int const&, hsize_t const [], string const&, string const&, hid_t)
                            {return false;}

    public :
      hdf_swath_dataset ();
      hdf_swath_dataset (string const&, int32, int, hsize_t const [], string const []);
      virtual ~hdf_swath_dataset () = 0;

      bool Define (hid_t);
      bool Define (hid_t, string const&, int32, int, hsize_t const [], string const [], string const);
      bool Write  (hid_t, int, VOIDP);
      bool Write  (hid_t, VOIDP);
  };

#endif
