/********** HDFFile.C *************************************************************************************************\

 $Header$

 REVISION HISTORY
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "HDFFile.h"
#include "DiagnosticReporter.h"

extern diagnostic_reporter diagnosticreporter;

hdf_file :: hdf_file ()
{
  isopen = false;
  fileid = 0;
  hdfeosid = 0;
  metadataid = 0;
}


hdf_file :: hdf_file (PGSt_PC_Logical filelogical)
          : processor_file (filelogical)
{
  isopen = false;
  fileid = 0;
  hdfeosid = 0;
  metadataid = 0;
}


hdf_file :: ~hdf_file ()
{
  ;
}


bool hdf_file :: Close ()
{
  bool isclosed = false;

  // proceed only if file is open
  if (isopen)

    // end vgroup access
    if (Vend (fileid) != FAIL)

      // close the file
      if (EHclose (hdfeosid) != FAIL) {
        isclosed = true;
        isopen = false;
      }

  if (! isclosed)
    diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_MOPCH_MODULE, CLOSE_WARNING, GetLogical (), 0, 0, 0,
                                 0, 0, 0, 0, "Could not close hdf file");

  return isclosed;
}


bool hdf_file :: Open (intn opencode)
{
  bool isopened = false;

  // proceed only if file is not already open
  if (! isopen)

    // open the file
    if ((hdfeosid = EHopen ((char*) (GetName()).c_str (), opencode)) != FAIL)

      // retrieve the metadata and file ids
      if (EHidinfo (hdfeosid, &fileid, &metadataid) != FAIL)

        // start vgroup access
        if (Vstart (fileid) != FAIL) {
	  isopen = true;
	  isopened = true;
        }

  string msg="metadataid";
  char ll[100];
  (void) sprintf(ll, "%d", metadataid );
  msg += ll;
  diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_MOPCH_MODULE, OPEN_ERROR, GetLogical (), 0, 0, 0, 0,
                                 0, 0, 0, msg);

  if (! isopened)
    diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_MOPCH_MODULE, OPEN_ERROR, GetLogical (), 0, 0, 0, 0,
                                 0, 0, 0, "Could not open hdf file");

  return isopened;
}
