/********** HDFEOSFile.C **********************************************************************************************\

 $Header$

 REVISION HISTORY
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "HDFEOSFile.h"
#include "DiagnosticReporter.h"
#include <PGS_SMF.h>

extern diagnostic_reporter diagnosticreporter;

hdfeos_file :: hdfeos_file ()
{
  isopen = false;
  fileid = 0;
  metadataid = 0;
}


hdfeos_file :: hdfeos_file (PGSt_PC_Logical filelogical)
             : processor_file (filelogical)
{
  isopen = false;
  fileid = 0;
  metadataid = 0;
}


hdfeos_file :: ~hdfeos_file ()
{
  ;
}


bool hdfeos_file :: Close () 
{
  bool isclosed = false;

  PGSt_integer version = 1;
  char filename [PGSd_PC_FILE_PATH_MAX]="";
  herr_t status = -1;
  hid_t HDF5fid;

  // proceed only if file is open
  if (isopen) {
    diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_HDF_MODULE, CLOSE_WARNING, GetLogical (), 0, 0, 0,
				 0, 0, 0, 0, "The hdfeos file is open");
    // close the swath
    if (HE5_SWclose (fileid) != FAIL) {
      isclosed = true;
      isopen = false;
    }
  }
  if (! isclosed)
    diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_HDF_MODULE, CLOSE_WARNING, GetLogical (), 0, 0, 0, 0,
                                 0, 0, 0, "Could not close hdfeos file");
  else
    diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_HDF_MODULE, CLOSE_WARNING, GetLogical (), 0, 0, 0, 0,
				 0, 0, 0, "done @ close hdfeos file w HE5_SWclose");

  // open & close the file with H5F functions again to make H5Fis_hdf5 working
  isclosed = false;
  if (PGS_PC_GetReference (GetLogical (), &version, filename) != PGS_S_SUCCESS)
    diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_HDF_MODULE, CLOSE_WARNING, GetLogical (),  0, 0, 0, 
				 0, 0, 0, 0, "Could not get MOP01 filename");
  else {
    HDF5fid = H5Fopen(filename, H5F_ACC_RDWR, H5P_DEFAULT);
    if ( HDF5fid < 0)
      diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_HDF_MODULE, CLOSE_WARNING, GetLogical (),  0, 0, 0, 
				   0, 0, 0, 0, "Could not open MOP01 filename w H5Fopen");
    else {
      status = H5Fclose(HDF5fid);
      if (status != FAIL) {
	isclosed = true;
	isopen = false;
      }
    }
  }
  if (! isclosed)
    diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_HDF_MODULE, CLOSE_WARNING, GetLogical (), 0, 0, 0, 0,
				 0, 0, 0, "Could not close hdfeos file w H5Fclose");
  diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_HDF_MODULE, CLOSE_WARNING, GetLogical (), 0, 0, 0, 0,
			       0, 0, 0, "done @ close hdfeos file w H5Fclose");

  return isclosed;
}


bool hdfeos_file :: Open (int opencode)
{
  bool isopened = false;
  PGSt_SMF_status status;
  char msg[PGS_SMF_MAX_MSG_SIZE];
  char err[PGS_SMF_MAX_MNEMONIC_SIZE];

  // proceed only if file is not already open
  if (! isopen)

    // open the swath
    if ((fileid = HE5_SWopen ((char*) (GetName ()).c_str (), opencode)) != FAIL) {

      // retrieve the metadata id
      hid_t dummy;
      status = HE5_EHidinfo (fileid, &dummy, &metadataid);
      if (status == PGS_S_SUCCESS){
        isopened = true;
        isopen = true;
      }
      else {
	PGS_SMF_GetMsg(&status, err, msg);
	diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_HDF_MODULE, OPEN_ERROR, GetLogical (), 0, 0, 0, 0, 
				     0, 0, 0, msg);
      }
    }

  if (! isopened)
    diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_HDF_MODULE, OPEN_ERROR, GetLogical (), 0, 0, 0, 0, 0, 0,
                                 0, "Could not open hdfeos file");

  return isopened;
}
