/********** ProcessorFile.h *******************************************************************************************\

 $Header$

 REVISION HISTORY
   12/98   Charles Cavanaugh
   09/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_PROCESSOR_FILE_
 
  #define _MOPITT_L1_PROCESSOR_FILE_

  #include "PGS_PC.h"
  #include <string>

  using namespace std;

  class processor_file {
    private :
      static int const INIT_ERROR;
      static int const INIT_WARNING;
      static int const REFERENCE_WARNING;

      bool            isinitialized;
      PGSt_PC_Logical logical;
      string          name;

    protected :
      static int const OPEN_ERROR;
      static int const OPEN_WARNING;
      static int const CLOSE_WARNING;

      bool Initialize ();
      bool Initialize (PGSt_PC_Logical);

    public :
      processor_file ();
      processor_file (PGSt_PC_Logical);
      virtual ~processor_file () = 0;

      PGSt_PC_Logical GetLogical () const {return logical;}
      string          GetName    () const {return name;}
  };

#endif
