/********** ProcessorFile.C *******************************************************************************************\

 $Header$

 REVISION HISTORY
   12/98   Charles Cavanaugh
   09/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "ProcessorFile.h"
#include "DiagnosticReporter.h"

int const processor_file::INIT_ERROR        = 900;
int const processor_file::INIT_WARNING      = 800;
int const processor_file::REFERENCE_WARNING = 802;
int const processor_file::OPEN_ERROR        = 901;
int const processor_file::OPEN_WARNING      = 801;
int const processor_file::CLOSE_WARNING     = 803;

extern diagnostic_reporter diagnosticreporter;

processor_file :: processor_file ()
                : name ()
{
  isinitialized = false;
  logical = 0;
}


processor_file :: processor_file (PGSt_PC_Logical filelogical)
                : name ()
{
  isinitialized = false;
  logical = filelogical;
}


processor_file :: ~processor_file ()
{
  ;
}


bool processor_file :: Initialize ()
{
  bool isinit = false;

  // make sure conditions are ok for initialization
  if (isinitialized)
    diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_FILE_MODULE, INIT_WARNING, logical, 0, 0, 0, 0, 0, 0,
                                 0, "Could not initialize already initialized file");
  else if (logical == 0)
    diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_FILE_MODULE, INIT_WARNING, 0, 0, 0, 0, 0, 0, 0, 0,
                                 "Could not initialize a file without a logical");
  else {
  
    // read the name
    PGSt_integer version = 1;
    char filename [PGSd_PC_FILE_PATH_MAX];
    if (PGS_PC_GetReference (logical, &version, filename) != PGS_S_SUCCESS)
      diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_FILE_MODULE, REFERENCE_WARNING, logical, 0, 0, 0, 
                                   0, 0, 0, 0, "Could not get filename");
    else {
      isinitialized = true;
      isinit = true;
      name = filename;
    }
  }

  return isinit;
}


bool processor_file :: Initialize (PGSt_PC_Logical filelogical)
{
  bool isinit = false;

  // make sure conditions are ok for initialization
  if (isinitialized)
    diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_FILE_MODULE, INIT_WARNING, logical, 0, 0, 0, 0, 0, 0,
                                 0, "Could not initialize already initialized file");
  else {

    // set the logical
    logical = filelogical;

    // read the name
    PGSt_integer version = 1;
    char filename [PGSd_PC_FILE_PATH_MAX];
    if (PGS_PC_GetReference (logical, &version, filename) != PGS_S_SUCCESS)
      diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_FILE_MODULE, REFERENCE_WARNING, logical, 0, 0, 0, 
                                   0, 0, 0, 0, "Could not get filename");
    else {

      isinitialized = true;
      isinit = true;
      name = filename;
    }
  }

  return isinit;
}
