/********** ASCIIWriteFile.C ******************************************************************************************\

 $Header$

 REVISION HISTORY
   12/98   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "ASCIIWriteFile.h"
#include "DiagnosticReporter.h"

extern diagnostic_reporter diagnosticreporter;

int const ascii_write_file::WRITE_ERROR = 905;

ascii_write_file :: ascii_write_file ()
                  : ascii_file ()
{
  ;
}


ascii_write_file :: ascii_write_file (PGSt_PC_Logical filelogical)
                  : ascii_file (filelogical)
{
  ;
}


ascii_write_file :: ~ascii_write_file ()
{
  ;
}


bool ascii_write_file :: Open ()
{
  bool isopen = false;

  // open the ascii file for writing and then set the handle to the end of the file
  if (ascii_file::Open (ASCII_OPEN_WRITE)) {
    isopen = true;
    fseek (handle, 0L, SEEK_END);
  }

  return isopen;
}


bool ascii_write_file :: Write (string const& ioentry) const
{
  bool iswritten = false;

  // if file is open, write the line and put a newline after it
  if (IsOpen ()) {
    if (fputs ((char*) ioentry.c_str (), handle) != EOF)
      if (fputc ('\n', handle) != EOF)
        iswritten = true;

    if (! iswritten)
      diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_FILE_MODULE, WRITE_ERROR, GetLogical (), 0, 0, 0, 0,
                                   0, 0, 0, "Could not write line to file");
  }

  return iswritten;
}
