/********** ASCIIReadFile.C *******************************************************************************************\

 $Header$

 REVISION HISTORY
   12/98   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "ASCIIReadFile.h"
#include "DiagnosticReporter.h"

extern diagnostic_reporter diagnosticreporter;

int const ascii_read_file::READ_ERROR = 904;

ascii_read_file :: ascii_read_file ()
                 : ascii_file ()
{
  length = 0;
  entry = NULL;
}


ascii_read_file :: ascii_read_file (int newlength)
                 : ascii_file ()
{
  length = newlength;
  entry = new char [length];
}


ascii_read_file :: ascii_read_file (PGSt_PC_Logical filelogical, int newlength)
                 : ascii_file (filelogical)
{
  length = newlength;
  entry = new char [length];
}


ascii_read_file :: ~ascii_read_file ()
{
  delete [] entry;
}


bool ascii_read_file :: Open ()
{
  bool isopen = false;

  // open the ascii file in read mode and then rewind the handle
  if (ascii_file::Open (ASCII_OPEN_READ)) {
    isopen = true;
    fseek (handle, 0L, SEEK_SET);
  }

  return isopen;
}


bool ascii_read_file :: Read (string& ioentry) const
{
  bool isread = false;

  // if file is open
  if (IsOpen ())

    // if read length is greather than 0
    if (length > 0)

      // if not at end of file (could not use feof because toolkit messes up handle)
      //if (handle->_cnt > 0 || handle->_flag == 1) {
      if ( !feof(handle) ) {

        // read the line
        if (fgets (entry, length, handle) != NULL) {
          isread = true;
          ioentry = entry;
        }
        else
          diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_FILE_MODULE, READ_ERROR, GetLogical (), 0, 0, 0,
                                       0, 0, 0, 0, "Could not read line from file");
      }

  return isread;
}
