/********** ASCIIFile.C ***********************************************************************************************\

 $Header$

 REVISION HISTORY
   12/98   Charles Cavanaugh
   09/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "PGS_IO.h"
#include "ASCIIFile.h"
#include "DiagnosticReporter.h"

extern diagnostic_reporter diagnosticreporter;

ascii_file :: ascii_file ()
            : processor_file ()
{
  isopen = false;
  handle = NULL;
}


ascii_file :: ascii_file (PGSt_PC_Logical filelogical)
            : processor_file (filelogical)
{
  isopen = false;
  handle = NULL;
}


ascii_file :: ~ascii_file ()
{
  ;
}


bool ascii_file :: Close ()
{
  bool isclosed = true;

  // proceed only if file is open
  if (isopen) {
    isopen = false;

    // close the file
    if (PGS_IO_Gen_Close (handle) != PGS_S_SUCCESS) {
      isclosed = false;
      diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_FILE_MODULE, CLOSE_WARNING, GetLogical (), 0, 0, 0,
                                   0, 0, 0, 0, "Could not close ASCII file");
    }
  }

  return isclosed;
}


bool ascii_file :: Open (enum ascii_file_open_code opencode)
{
  bool isopened = false;

  // is the file is already open, report warning
  if (isopen)
    diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_FILE_MODULE, OPEN_WARNING, GetLogical (), 0, 0, 0, 0,
                                 0, 0, 0, "Could not open already open ASCII file");
  else {

    // initialize the objects
    if (Initialize ()) {

      // open the file
      PGSt_IO_Gen_AccessType pgscode = (opencode == ASCII_OPEN_READ ? PGSd_IO_Gen_Read : PGSd_IO_Gen_Write);
      PGSt_integer sequence = 1;
      if (PGS_IO_Gen_Open (GetLogical (), pgscode, &handle, sequence) != PGS_S_SUCCESS)
        diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_FILE_MODULE, OPEN_ERROR, GetLogical (), 0, 0, 0, 0,
                                     0, 0, 0, "Could not open ASCII file");
      else {
        isopen = true;
        isopened = true;
      }
    }
  }

  return isopened;
}
