/********** EngineeringTrain4TelemGroup.h *****************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh
   02/00   Tom Lauren

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_ENGINEERING_TRAIN4_TELEM_GROUP_

  #define _MOPITT_L1_ENGINEERING_TRAIN4_TELEM_GROUP_

  #include "EngineeringDataConstants.h"
  #include "EngineeringDataGroup.h"
  #include "MOPIPFile.h"

  class engineering_train4_telem_group : public engineering_data_group {
    private :
      static int const BLACKBODY_4_PRT_1_TEMPERATURE_OFFSET;
      static int const BLACKBODY_4_PRT_1_HIGH_REFERENCE_OFFSET;
      static int const BLACKBODY_4_PRT_1_LOW_REFERENCE_OFFSET;
      static int const BLACKBODY_4_PRT_2_TEMPERATURE_OFFSET;
      static int const BLACKBODY_4_PRT_2_HIGH_REFERENCE_OFFSET;
      static int const BLACKBODY_4_PRT_2_LOW_REFERENCE_OFFSET;
      static int const BLACKBODY_4_HEATER_VOLTAGE_OFFSET;
      static int const CHOPPER_4_TEMPERATURE_OFFSET;
      static int const LMC_4_GAS_TEMPERATURE_OFFSET;
      static int const LMC_4_PRESSURE_TEMPERATURE_OFFSET;
      static int const LMC_4_PRESSURE_OFFSET;
      static int const LMC_4_PRESSURE_HIGH_REFERENCE_OFFSET;
      static int const LMC_4_PRESSURE_LOW_REFERENCE_OFFSET;
      static int const DETECTOR_7_TEMPERATURE_OFFSET;
      static int const DETECTOR_8_TEMPERATURE_OFFSET;
      static int const COLD_FILTER_7_TEMPERATURE_OFFSET;
      static int const SIEVE_4_TEMPERATURE_OFFSET;
      static int const SIEVE_4_HIGH_REFERENCE_OFFSET;
      static int const SIEVE_4_LOW_REFERENCE_OFFSET;
      static int const SIEVE_4_HEATER_VOLTAGE_OFFSET;
      static int const PMC_2_GAS_TEMPERATURE_OFFSET;
      static int const PMC_2_PICKOFF_AMPLITUDE_OFFSET;
      static int const PMC_2_PHASE_ERROR_OFFSET;
      static int const FIELDCOUNT;

      enum engineering_train4_telem_sensor { BLACKBODY_4_PRT_1_TEMPERATURE,    BLACKBODY_4_PRT_1_HIGH_REFERENCE,
                                             BLACKBODY_4_PRT_1_LOW_REFERENCE,  BLACKBODY_4_PRT_2_TEMPERATURE,
                                             BLACKBODY_4_PRT_2_HIGH_REFERENCE, BLACKBODY_4_PRT_2_LOW_REFERENCE,
                                             BLACKBODY_4_HEATER_VOLTAGE,       
                                             CHOPPER_4_TEMPERATURE,            LMC_4_GAS_TEMPERATURE,
                                             LMC_4_PRESSURE_TEMPERATURE,       LMC_4_PRESSURE,
                                             LMC_4_PRESSURE_HIGH_REFERENCE,    LMC_4_PRESSURE_LOW_REFERENCE,
                                             DETECTOR_7_TEMPERATURE,           DETECTOR_8_TEMPERATURE,
                                             COLD_FILTER_7_TEMPERATURE,        SIEVE_4_TEMPERATURE,
                                             SIEVE_4_HIGH_REFERENCE,           SIEVE_4_LOW_REFERENCE,
                                             SIEVE_4_HEATER_VOLTAGE,           PMC_2_GAS_TEMPERATURE,
                                             PMC_2_PICKOFF_AMPLITUDE,          PMC_2_PHASE_ERROR };

    protected :

    public :
      engineering_train4_telem_group ();
      ~engineering_train4_telem_group ();

      void  AddBlock            (unsigned char*);
      bool  Define              (int32, int32, string const&, string const&);
      float GetEventTemperature (int, int, mopip_file const&);
      void  GetSummaryData      (int, int, mopip_file const&, float [DIODE_BANKS] [ENGINEERING_STATES], 
                                 float [DIODE_BANKS] [ENGINEERING_STATES], 
                                 float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                 float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                 float [ENGINEERING_SUMMARY_VALUES] [ENGINEERING_STATES]);
      void  GetSwathData        (int, int, mopip_file const&, float [DIODE_BANKS] [ENGINEERING_STATES], 
                                 float [DIODE_BANKS] [ENGINEERING_STATES], 
                                 float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                 float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                 float [ENGINEERING_SWATH_VALUES] [ENGINEERING_STATES]);
  };

#endif
