/********** EngineeringTrain4TelemGroup.C *****************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh
   02/00   Tom Lauren

 $Log$

\**********************************************************************************************************************/

#include "EngineeringTrain4TelemGroup.h"

int const engineering_train4_telem_group::BLACKBODY_4_PRT_1_TEMPERATURE_OFFSET    = 36;
int const engineering_train4_telem_group::BLACKBODY_4_PRT_1_HIGH_REFERENCE_OFFSET = 38;
int const engineering_train4_telem_group::BLACKBODY_4_PRT_1_LOW_REFERENCE_OFFSET  = 40;
int const engineering_train4_telem_group::BLACKBODY_4_PRT_2_TEMPERATURE_OFFSET    = 42;
int const engineering_train4_telem_group::BLACKBODY_4_PRT_2_HIGH_REFERENCE_OFFSET = 44;
int const engineering_train4_telem_group::BLACKBODY_4_PRT_2_LOW_REFERENCE_OFFSET  = 46;
int const engineering_train4_telem_group::BLACKBODY_4_HEATER_VOLTAGE_OFFSET       = 214;
int const engineering_train4_telem_group::CHOPPER_4_TEMPERATURE_OFFSET            = 134;
int const engineering_train4_telem_group::LMC_4_GAS_TEMPERATURE_OFFSET            = 54;
int const engineering_train4_telem_group::LMC_4_PRESSURE_TEMPERATURE_OFFSET       = 170;
int const engineering_train4_telem_group::LMC_4_PRESSURE_OFFSET                   = 190;
int const engineering_train4_telem_group::LMC_4_PRESSURE_HIGH_REFERENCE_OFFSET    = 192;
int const engineering_train4_telem_group::LMC_4_PRESSURE_LOW_REFERENCE_OFFSET     = 194;
int const engineering_train4_telem_group::DETECTOR_7_TEMPERATURE_OFFSET           = 108;
int const engineering_train4_telem_group::DETECTOR_8_TEMPERATURE_OFFSET           = 110;
int const engineering_train4_telem_group::COLD_FILTER_7_TEMPERATURE_OFFSET        = 94;
int const engineering_train4_telem_group::SIEVE_4_TEMPERATURE_OFFSET              = 78;
int const engineering_train4_telem_group::SIEVE_4_HIGH_REFERENCE_OFFSET           = 80;
int const engineering_train4_telem_group::SIEVE_4_LOW_REFERENCE_OFFSET            = 82;
int const engineering_train4_telem_group::SIEVE_4_HEATER_VOLTAGE_OFFSET           = 222;
int const engineering_train4_telem_group::PMC_2_GAS_TEMPERATURE_OFFSET            = 58;
int const engineering_train4_telem_group::PMC_2_PICKOFF_AMPLITUDE_OFFSET          = 198;
int const engineering_train4_telem_group::PMC_2_PHASE_ERROR_OFFSET                = 202;
int const engineering_train4_telem_group::FIELDCOUNT                              = 23;

engineering_train4_telem_group :: engineering_train4_telem_group ()
                                : engineering_data_group ()
{
  ;
}


engineering_train4_telem_group :: ~engineering_train4_telem_group ()
{
  ;
}


void engineering_train4_telem_group :: AddBlock (unsigned char* blockdata)
{
  // make the container to hold the data we want
  unsigned short* telemdata = new unsigned short [FIELDCOUNT];

  // unpack the data
  telemdata [BLACKBODY_4_PRT_1_TEMPERATURE]    = UnpackData (&blockdata [BLACKBODY_4_PRT_1_TEMPERATURE_OFFSET]);
  telemdata [BLACKBODY_4_PRT_1_HIGH_REFERENCE] = UnpackData (&blockdata [BLACKBODY_4_PRT_1_HIGH_REFERENCE_OFFSET]);
  telemdata [BLACKBODY_4_PRT_1_LOW_REFERENCE]  = UnpackData (&blockdata [BLACKBODY_4_PRT_1_LOW_REFERENCE_OFFSET]);
  telemdata [BLACKBODY_4_PRT_2_TEMPERATURE]    = UnpackData (&blockdata [BLACKBODY_4_PRT_2_TEMPERATURE_OFFSET]);
  telemdata [BLACKBODY_4_PRT_2_HIGH_REFERENCE] = UnpackData (&blockdata [BLACKBODY_4_PRT_2_HIGH_REFERENCE_OFFSET]);
  telemdata [BLACKBODY_4_PRT_2_LOW_REFERENCE]  = UnpackData (&blockdata [BLACKBODY_4_PRT_2_LOW_REFERENCE_OFFSET]);
  telemdata [BLACKBODY_4_HEATER_VOLTAGE]       = UnpackData (&blockdata [BLACKBODY_4_HEATER_VOLTAGE_OFFSET]);
  telemdata [CHOPPER_4_TEMPERATURE]            = UnpackData (&blockdata [CHOPPER_4_TEMPERATURE_OFFSET]);
  telemdata [LMC_4_GAS_TEMPERATURE]            = UnpackData (&blockdata [LMC_4_GAS_TEMPERATURE_OFFSET]);
  telemdata [LMC_4_PRESSURE_TEMPERATURE]       = UnpackData (&blockdata [LMC_4_PRESSURE_TEMPERATURE_OFFSET]);
  telemdata [LMC_4_PRESSURE]                   = UnpackData (&blockdata [LMC_4_PRESSURE_OFFSET]);
  telemdata [LMC_4_PRESSURE_HIGH_REFERENCE]    = UnpackData (&blockdata [LMC_4_PRESSURE_HIGH_REFERENCE_OFFSET]);
  telemdata [LMC_4_PRESSURE_LOW_REFERENCE]     = UnpackData (&blockdata [LMC_4_PRESSURE_LOW_REFERENCE_OFFSET]);
  telemdata [DETECTOR_7_TEMPERATURE]           = UnpackData (&blockdata [DETECTOR_7_TEMPERATURE_OFFSET]);
  telemdata [DETECTOR_8_TEMPERATURE]           = UnpackData (&blockdata [DETECTOR_8_TEMPERATURE_OFFSET]);
  telemdata [COLD_FILTER_7_TEMPERATURE]        = UnpackData (&blockdata [COLD_FILTER_7_TEMPERATURE_OFFSET]);
  telemdata [SIEVE_4_TEMPERATURE]              = UnpackData (&blockdata [SIEVE_4_TEMPERATURE_OFFSET]);
  telemdata [SIEVE_4_HIGH_REFERENCE]           = UnpackData (&blockdata [SIEVE_4_HIGH_REFERENCE_OFFSET]);
  telemdata [SIEVE_4_LOW_REFERENCE]            = UnpackData (&blockdata [SIEVE_4_LOW_REFERENCE_OFFSET]);
  telemdata [SIEVE_4_HEATER_VOLTAGE]           = UnpackData (&blockdata [SIEVE_4_HEATER_VOLTAGE_OFFSET]);
  telemdata [PMC_2_GAS_TEMPERATURE]            = UnpackData (&blockdata [PMC_2_GAS_TEMPERATURE_OFFSET]);
  telemdata [PMC_2_PICKOFF_AMPLITUDE]          = UnpackData (&blockdata [PMC_2_PICKOFF_AMPLITUDE_OFFSET]);
  telemdata [PMC_2_PHASE_ERROR]                = UnpackData (&blockdata [PMC_2_PHASE_ERROR_OFFSET]);

  // add the container to the list
  datalist.AddData (telemdata);
}


bool engineering_train4_telem_group :: Define (int32 fileid, int32 groupid, string const& groupclass,
                                               string const& dataclass)
{
  string const fieldnames [FIELDCOUNT] = {"Blackbody 4 PRT 1 Temperature", "Blackbody 4 PRT 1 High Reference",
                                          "Blackbody 4 PRT 1 Low Reference", "Blackbody 4 PRT 2 Temperature",
                                          "Blackbody 4 PRT 2 High Reference", "Blackbody 4 PRT 2 Low Reference",
                                          "Blackbody 4 Heater Voltage", "Chopper 4 Temperature",
                                          "LMC 4 Gas Temperature", "LMC 4 Pressure Temperature", "LMC 4 Pressure",
                                          "LMC 4 Pressure High Reference", "LMC 4 Pressure Low Reference",
                                          "Detector 7 Temperature", "Detector 8 Temperature", 
                                          "Cold Filter 7 Temperature", "Sieve 4 Temperature", "Sieve 4 High Reference",
                                          "Sieve 4 Low Reference", "Sieve 4 Heater Voltage", "PMC 2 Gas Temperature",
                                          "PMC 2 Pickoff Amplitude", "PMC 2 Phase Error"};
  int32 const datatypes [FIELDCOUNT] = {DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16,
                                        DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16,
                                        DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16,
                                        DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16};
  int32 const orders [FIELDCOUNT] = {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};

  return engineering_data_group::Define (fileid, groupid, "Engineering Train4 Telem Group", groupclass,
                                         "Engineering Train4 Telem Data", dataclass, FIELDCOUNT, fieldnames, datatypes,
                                         orders);
}


float engineering_train4_telem_group :: GetEventTemperature (int startindex, int stopindex, mopip_file const& mopipfile)
{
  // get the average readings for bb1 temp, hi ref and lo ref; use mopip to convert to units
  float bb1sensor [ENGINEERING_STATES], bb1hiref [ENGINEERING_STATES], bb1loref [ENGINEERING_STATES];
  datalist.GetAverageValue ((int) BLACKBODY_4_PRT_1_TEMPERATURE,    startindex, stopindex, bb1sensor);
  datalist.GetAverageValue ((int) BLACKBODY_4_PRT_1_HIGH_REFERENCE, startindex, stopindex, bb1hiref);
  datalist.GetAverageValue ((int) BLACKBODY_4_PRT_1_LOW_REFERENCE,  startindex, stopindex, bb1loref);
  float bb1temp [ENGINEERING_STATES];
  mopipfile.Compute (BlackbodyTemperature4_1, bb1sensor, bb1hiref, bb1loref, bb1temp);

  // get the average readings for bb2 temp, hi ref and lo ref; use mopip to convert to units
  float bb2sensor [ENGINEERING_STATES], bb2hiref [ENGINEERING_STATES], bb2loref [ENGINEERING_STATES];
  datalist.GetAverageValue ((int) BLACKBODY_4_PRT_2_TEMPERATURE,    startindex, stopindex, bb2sensor);
  datalist.GetAverageValue ((int) BLACKBODY_4_PRT_2_HIGH_REFERENCE, startindex, stopindex, bb2hiref);
  datalist.GetAverageValue ((int) BLACKBODY_4_PRT_2_LOW_REFERENCE,  startindex, stopindex, bb2loref);
  float bb2temp [ENGINEERING_STATES];
  mopipfile.Compute (BlackbodyTemperature4_2, bb2sensor, bb2hiref, bb2loref, bb2temp);

  return ((bb1temp [ENGINEERING_AVERAGE_VALUE] + bb2temp [ENGINEERING_AVERAGE_VALUE]) / 2.0);
}


void engineering_train4_telem_group :: GetSummaryData (int startindex, int stopindex, mopip_file const& mopipfile, 
                                                       float diodehighrefs [DIODE_BANKS] [ENGINEERING_STATES], 
                                                       float diodelowrefs [DIODE_BANKS] [ENGINEERING_STATES], 
                                                       float thermistorhighrefs [THERMISTOR_BANKS] [ENGINEERING_STATES],
                                                       float thermistorlowrefs [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                                    float summarydata [ENGINEERING_SUMMARY_VALUES] [ENGINEERING_STATES])
{
  float sensor [ENGINEERING_STATES], highref [ENGINEERING_STATES], lowref [ENGINEERING_STATES];
  short bank;

  datalist.GetAverageValue ((int) BLACKBODY_4_PRT_1_TEMPERATURE, startindex, stopindex, sensor);
  datalist.GetAverageValue ((int) BLACKBODY_4_PRT_1_HIGH_REFERENCE, startindex, stopindex, highref);
  datalist.GetAverageValue ((int) BLACKBODY_4_PRT_1_LOW_REFERENCE,  startindex, stopindex, lowref);
  mopipfile.Compute (BlackbodyTemperature4_1, sensor, highref, lowref, summarydata[SUMMARY_BLACKBODY_4_TEMPERATURE_1]);

  datalist.GetAverageValue ((int) BLACKBODY_4_PRT_2_TEMPERATURE, startindex, stopindex, sensor);
  datalist.GetAverageValue ((int) BLACKBODY_4_PRT_2_HIGH_REFERENCE, startindex, stopindex, highref);
  datalist.GetAverageValue ((int) BLACKBODY_4_PRT_2_LOW_REFERENCE,  startindex, stopindex, lowref);
  mopipfile.Compute (BlackbodyTemperature4_2, sensor, highref, lowref, summarydata[SUMMARY_BLACKBODY_4_TEMPERATURE_2]);

  datalist.GetAverageValue ((int) BLACKBODY_4_HEATER_VOLTAGE, startindex, stopindex, sensor);
  mopipfile.Compute (BlackbodyHeaterVoltage4, sensor, summarydata[SUMMARY_BLACKBODY_4_HEATER_VOLTAGE]);

  datalist.GetAverageValue ((int) CHOPPER_4_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (ChopperTemperature4);
  mopipfile.Compute (ChopperTemperature4, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     summarydata[SUMMARY_CHOPPER_4_TEMPERATURE]);

  datalist.GetAverageValue ((int) LMC_4_GAS_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (LMCTemperature4);
  mopipfile.Compute (LMCTemperature4, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     summarydata[SUMMARY_LMC_4_TEMPERATURE]);

  datalist.GetAverageValue ((int) LMC_4_PRESSURE_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (LMCPressureTemperature4);
  mopipfile.Compute (LMCPressureTemperature4, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     summarydata[SUMMARY_LMC_4_PRESSURE_TEMPERATURE]);

  datalist.GetAverageValue ((int) LMC_4_PRESSURE,                startindex, stopindex, sensor);
  datalist.GetAverageValue ((int) LMC_4_PRESSURE_HIGH_REFERENCE, startindex, stopindex, highref);
  datalist.GetAverageValue ((int) LMC_4_PRESSURE_LOW_REFERENCE,  startindex, stopindex, lowref);
  mopipfile.Compute (LMCPressure4, sensor, highref, lowref, summarydata[SUMMARY_LMC_4_PRESSURE]);

  datalist.GetAverageValue ((int) DETECTOR_7_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (DetectorTemperature7);
  mopipfile.Compute (DetectorTemperature7, sensor, diodehighrefs[bank - 1], diodelowrefs[bank - 1],
                     summarydata[SUMMARY_DETECTOR_7_TEMPERATURE]);

  datalist.GetAverageValue ((int) DETECTOR_8_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (DetectorTemperature8);
  mopipfile.Compute (DetectorTemperature8, sensor, diodehighrefs[bank - 1], diodelowrefs[bank - 1],
                     summarydata[SUMMARY_DETECTOR_8_TEMPERATURE]);

  datalist.GetAverageValue ((int) COLD_FILTER_7_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (ColdFilterTemperature7);
  mopipfile.Compute (ColdFilterTemperature7, sensor, diodehighrefs[bank - 1], diodelowrefs[bank - 1],
                     summarydata[SUMMARY_COLD_FILTER_7_TEMPERATURE]);

  datalist.GetAverageValue ((int) SIEVE_4_TEMPERATURE, startindex, stopindex, sensor);
  datalist.GetAverageValue ((int) SIEVE_4_HIGH_REFERENCE, startindex, stopindex, highref);
  datalist.GetAverageValue ((int) SIEVE_4_LOW_REFERENCE,  startindex, stopindex, lowref);
  mopipfile.Compute (SieveTemperature4, sensor, highref, lowref, summarydata[SUMMARY_SIEVE_4_TEMPERATURE]);

  datalist.GetAverageValue ((int) SIEVE_4_HEATER_VOLTAGE, startindex, stopindex, sensor);
  mopipfile.Compute (SieveHeaterVoltage4, sensor, summarydata[SUMMARY_SIEVE_4_HEATER_VOLTAGE]);

  datalist.GetAverageValue ((int) PMC_2_GAS_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (PMCTemperature2);
  mopipfile.Compute (PMCTemperature2, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     summarydata[SUMMARY_PMC_2_TEMPERATURE]);

  datalist.GetAverageValue ((int) PMC_2_PICKOFF_AMPLITUDE, startindex, stopindex, sensor);
  mopipfile.Compute (PMCAmplitude2, sensor, summarydata[SUMMARY_PMC_2_AMPLITUDE]);

  datalist.GetAverageValue ((int) PMC_2_PHASE_ERROR, startindex, stopindex, sensor);
  mopipfile.Compute (PMCPhaseError2, sensor, summarydata[SUMMARY_PMC_2_PHASE_ERROR]);
}


void engineering_train4_telem_group :: GetSwathData (int startindex, int stopindex, mopip_file const& mopipfile, 
                                                     float diodehighrefs [DIODE_BANKS] [ENGINEERING_STATES], 
                                                     float diodelowrefs [DIODE_BANKS] [ENGINEERING_STATES], 
                                                     float thermistorhighrefs [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                                     float thermistorlowrefs [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                                     float swathdata [ENGINEERING_SWATH_VALUES] [ENGINEERING_STATES])
{
  float sensor [ENGINEERING_STATES], highref [ENGINEERING_STATES], lowref [ENGINEERING_STATES];
  short bank;

  datalist.GetAverageValue ((int) CHOPPER_4_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (ChopperTemperature4);
  mopipfile.Compute (ChopperTemperature4, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     swathdata[SWATH_CHOPPER_4_TEMPERATURE]);

  datalist.GetAverageValue ((int) COLD_FILTER_7_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (ColdFilterTemperature7);
  mopipfile.Compute (ColdFilterTemperature7, sensor, diodehighrefs[bank - 1], diodelowrefs[bank - 1],
                     swathdata[SWATH_COLDFILTER_7_TEMPERATURE]);

  datalist.GetAverageValue ((int) DETECTOR_7_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (DetectorTemperature7);
  mopipfile.Compute (DetectorTemperature7, sensor, diodehighrefs[bank - 1], diodelowrefs[bank - 1],
                     swathdata[SWATH_DETECTOR_7_TEMPERATURE]);

  datalist.GetAverageValue ((int) DETECTOR_8_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (DetectorTemperature8);
  mopipfile.Compute (DetectorTemperature8, sensor, diodehighrefs[bank - 1], diodelowrefs[bank - 1],
                     swathdata[SWATH_DETECTOR_8_TEMPERATURE]);

  datalist.GetAverageValue ((int) LMC_4_GAS_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (LMCTemperature4);
  mopipfile.Compute (LMCTemperature4, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     swathdata[SWATH_LMC_4_SHROUD_TEMPERATURE]);

  datalist.GetAverageValue ((int) LMC_4_PRESSURE_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (LMCPressureTemperature4);
  mopipfile.Compute (LMCPressureTemperature4, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     swathdata[SWATH_LMC_4_PRESSURE_TEMPERATURE]);

  datalist.GetAverageValue ((int) LMC_4_PRESSURE,                startindex, stopindex, sensor);
  datalist.GetAverageValue ((int) LMC_4_PRESSURE_HIGH_REFERENCE, startindex, stopindex, highref);
  datalist.GetAverageValue ((int) LMC_4_PRESSURE_LOW_REFERENCE,  startindex, stopindex, lowref);
  mopipfile.Compute (LMCPressure4, sensor, highref, lowref, swathdata[SWATH_LMC_4_PRESSURE]);

  datalist.GetAverageValue ((int) PMC_2_GAS_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (PMCTemperature2);
  mopipfile.Compute (PMCTemperature2, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     swathdata[SWATH_PMC_2_SHROUD_TEMPERATURE]);

  swathdata [SWATH_PMC_2_HIGH_STROKE_PRESSURE] [ENGINEERING_AVERAGE_VALUE] = ENGINEERING_MISSING_VALUE;
  swathdata [SWATH_PMC_2_HIGH_STROKE_PRESSURE] [ENGINEERING_VARIANCE_VALUE] = ENGINEERING_MISSING_VALUE;
  swathdata [SWATH_PMC_2_LOW_STROKE_PRESSURE]  [ENGINEERING_AVERAGE_VALUE] = ENGINEERING_MISSING_VALUE;
  swathdata [SWATH_PMC_2_LOW_STROKE_PRESSURE]  [ENGINEERING_VARIANCE_VALUE] = ENGINEERING_MISSING_VALUE;
}
