/********** EngineeringTrain4Data.h ***********************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_ENGINEERING_TRAIN4_DATA_

  #define _MOPITT_L1_ENGINEERING_TRAIN4_DATA_

  #include "EngineeringBlock.h"
  #include "EngineeringTrain4TelemGroup.h"
  #include "EngineeringTrain4Block4Group.h"
  #include "EngineeringTrain4Block5Group.h"

  class engineering_train4_data {
    private :
      engineering_train4_telem_group  telemgroup;
      engineering_train4_block4_group block4group;
      engineering_train4_block5_group block5group;
      hdf_vgroup                      vgroup;

    protected :

    public :
      engineering_train4_data ();
      ~engineering_train4_data ();

      void  AddBlock             (engineering_block*);
      bool  Close                ();
      bool  Define               (int32, int32, string const&);
      float GetEventTemperature  (int, int, mopip_file const&);
      void  GetTelemSummaryData  (int, int, mopip_file const&, float [DIODE_BANKS] [ENGINEERING_STATES], 
                                  float [DIODE_BANKS] [ENGINEERING_STATES], 
                                  float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                  float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                  float [ENGINEERING_SUMMARY_VALUES][ENGINEERING_STATES]);
      void  GetBlock4SummaryData (int, int, mopip_file const&, float [ENGINEERING_SUMMARY_VALUES][ENGINEERING_STATES]);
      void  GetBlock5SummaryData (int, int, mopip_file const&, float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                  float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                  float [ENGINEERING_SUMMARY_VALUES][ENGINEERING_STATES]);
      void  GetSwathData         (int, int, mopip_file const&, float [DIODE_BANKS] [ENGINEERING_STATES], 
                                  float [DIODE_BANKS] [ENGINEERING_STATES], 
                                  float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                  float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                  float [ENGINEERING_SWATH_VALUES][ENGINEERING_STATES]);
      bool  Write                ();
  };

#endif
