/********** EngineeringTrain4Block4Group.C ****************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "EngineeringTrain4Block4Group.h"

int const engineering_train4_block4_group::MIRROR_4_MOTOR_CURRENT_OFFSET  = 16;
int const engineering_train4_block4_group::CHOPPER_4_MOTOR_CURRENT_OFFSET = 24;
int const engineering_train4_block4_group::LMC_4_MOTOR_CURRENT_OFFSET     = 32;
int const engineering_train4_block4_group::PMC_2_MOTOR_CURRENT_OFFSET     = 36;
int const engineering_train4_block4_group::FIELDCOUNT                     = 4;

engineering_train4_block4_group :: engineering_train4_block4_group ()
                                 : engineering_data_group ()
{
  ;
}


engineering_train4_block4_group :: ~engineering_train4_block4_group ()
{
  ;
}


void engineering_train4_block4_group :: AddBlock (unsigned char* blockdata)
{
  // make the container to hold the data we want
  unsigned short* housedata = new unsigned short [FIELDCOUNT];

  // unpack the data
  housedata [MIRROR_4_MOTOR_CURRENT]  = UnpackData (&blockdata [MIRROR_4_MOTOR_CURRENT_OFFSET]);
  housedata [CHOPPER_4_MOTOR_CURRENT] = UnpackData (&blockdata [CHOPPER_4_MOTOR_CURRENT_OFFSET]);
  housedata [LMC_4_MOTOR_CURRENT]     = UnpackData (&blockdata [LMC_4_MOTOR_CURRENT_OFFSET]);
  housedata [PMC_2_MOTOR_CURRENT]     = UnpackData (&blockdata [PMC_2_MOTOR_CURRENT_OFFSET]);

  // add the container to the list
  datalist.AddData (housedata);
}


bool engineering_train4_block4_group :: Define (int32 fileid, int32 groupid, string const& groupclass,
                                                string const& dataclass)
{
  string const fieldnames [FIELDCOUNT] = {"Mirror 4 Motor Current", "Chopper 4 Motor Current", "LMC 4 Motor Current",
                                          "PMC 2 Motor Current"};
  int32 const datatypes [FIELDCOUNT] = {DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16};
  int32 const orders [FIELDCOUNT] = {1, 1, 1, 1};

  return engineering_data_group::Define (fileid, groupid, "Engineering Train4 Block4 Group", groupclass,
                                         "Engineering Train4 Block4 Data", dataclass, FIELDCOUNT, fieldnames, 
                                         datatypes, orders);
}


void engineering_train4_block4_group :: GetSummaryData (int startindex, int stopindex, mopip_file const& mopipfile, 
                                                    float summarydata [ENGINEERING_SUMMARY_VALUES] [ENGINEERING_STATES])
{
  float sensor [ENGINEERING_STATES];

  datalist.GetAverageValue ((int) MIRROR_4_MOTOR_CURRENT, startindex, stopindex, sensor);
  mopipfile.Compute (MirrorMotorCurrent4, sensor, summarydata[SUMMARY_MIRROR_4_MOTOR_CURRENT]);

  datalist.GetAverageValue ((int) CHOPPER_4_MOTOR_CURRENT, startindex, stopindex, sensor);
  mopipfile.Compute (ChopperMotorCurrent4, sensor, summarydata[SUMMARY_CHOPPER_4_MOTOR_CURRENT]);

  datalist.GetAverageValue ((int) LMC_4_MOTOR_CURRENT, startindex, stopindex, sensor);
  mopipfile.Compute (LMCMotorCurrent4, sensor, summarydata[SUMMARY_LMC_4_MOTOR_CURRENT]);

  datalist.GetAverageValue ((int) PMC_2_MOTOR_CURRENT, startindex, stopindex, sensor);
  mopipfile.Compute (PMCMotorCurrent2, sensor, summarydata[SUMMARY_PMC_2_MOTOR_CURRENT]);
}
