/********** EngineeringTrain3TelemGroup.h *****************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh
   02/00   Tom Lauren

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_ENGINEERING_TRAIN3_TELEM_GROUP_

  #define _MOPITT_L1_ENGINEERING_TRAIN3_TELEM_GROUP_

  #include "EngineeringDataConstants.h"
  #include "EngineeringDataGroup.h"
  #include "MOPIPFile.h"

  class engineering_train3_telem_group : public engineering_data_group {
    private :
      static int const BLACKBODY_3_PRT_1_TEMPERATURE_OFFSET;
      static int const BLACKBODY_3_PRT_1_HIGH_REFERENCE_OFFSET;
      static int const BLACKBODY_3_PRT_1_LOW_REFERENCE_OFFSET;
      static int const BLACKBODY_3_PRT_2_TEMPERATURE_OFFSET;
      static int const BLACKBODY_3_PRT_2_HIGH_REFERENCE_OFFSET;
      static int const BLACKBODY_3_PRT_2_LOW_REFERENCE_OFFSET;
      static int const BLACKBODY_3_HEATER_VOLTAGE_OFFSET;
      static int const CHOPPER_3_TEMPERATURE_OFFSET;
      static int const LMC_3_GAS_TEMPERATURE_OFFSET;
      static int const LMC_3_PRESSURE_TEMPERATURE_OFFSET;
      static int const LMC_3_PRESSURE_OFFSET;
      static int const LMC_3_PRESSURE_HIGH_REFERENCE_OFFSET;
      static int const LMC_3_PRESSURE_LOW_REFERENCE_OFFSET;
      static int const DETECTOR_5_TEMPERATURE_OFFSET;
      static int const DETECTOR_6_TEMPERATURE_OFFSET;
      static int const COLD_FILTER_5_TEMPERATURE_OFFSET;
      static int const SIEVE_3_TEMPERATURE_OFFSET;
      static int const SIEVE_3_HIGH_REFERENCE_OFFSET;
      static int const SIEVE_3_LOW_REFERENCE_OFFSET;
      static int const SIEVE_3_HEATER_VOLTAGE_OFFSET;
      static int const FIELDCOUNT;

      enum engineering_train1_telem_sensor { BLACKBODY_3_PRT_1_TEMPERATURE,    BLACKBODY_3_PRT_1_HIGH_REFERENCE,
                                             BLACKBODY_3_PRT_1_LOW_REFERENCE,  BLACKBODY_3_PRT_2_TEMPERATURE,
                                             BLACKBODY_3_PRT_2_HIGH_REFERENCE, BLACKBODY_3_PRT_2_LOW_REFERENCE,
                                             BLACKBODY_3_HEATER_VOLTAGE,       
                                             CHOPPER_3_TEMPERATURE,            LMC_3_GAS_TEMPERATURE,
                                             LMC_3_PRESSURE_TEMPERATURE,       LMC_3_PRESSURE,
                                             LMC_3_PRESSURE_HIGH_REFERENCE,    LMC_3_PRESSURE_LOW_REFERENCE,
                                             DETECTOR_5_TEMPERATURE,           DETECTOR_6_TEMPERATURE,
                                             COLD_FILTER_5_TEMPERATURE,        SIEVE_3_TEMPERATURE,
                                             SIEVE_3_HIGH_REFERENCE,           SIEVE_3_LOW_REFERENCE,
                                             SIEVE_3_HEATER_VOLTAGE };

    protected :

    public :
      engineering_train3_telem_group ();
      ~engineering_train3_telem_group ();

      void  AddBlock            (unsigned char*);
      bool  Define              (int32, int32, string const&, string const&);
      float GetEventTemperature (int, int, mopip_file const&);
      void  GetSummaryData      (int, int, mopip_file const&, float [DIODE_BANKS] [ENGINEERING_STATES], 
                                 float [DIODE_BANKS] [ENGINEERING_STATES], 
                                 float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                 float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                 float [ENGINEERING_SUMMARY_VALUES] [ENGINEERING_STATES]);
      void  GetSwathData        (int, int, mopip_file const&, float [DIODE_BANKS] [ENGINEERING_STATES], 
                                 float [DIODE_BANKS] [ENGINEERING_STATES], 
                                 float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                 float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                 float [ENGINEERING_SWATH_VALUES] [ENGINEERING_STATES]);
  };

#endif
