/********** EngineeringTrain3TelemGroup.C *****************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh
   02/00   Tom Lauren

 $Log$

\**********************************************************************************************************************/

#include "EngineeringTrain3TelemGroup.h"

int const engineering_train3_telem_group::BLACKBODY_3_PRT_1_TEMPERATURE_OFFSET    = 24;
int const engineering_train3_telem_group::BLACKBODY_3_PRT_1_HIGH_REFERENCE_OFFSET = 26;
int const engineering_train3_telem_group::BLACKBODY_3_PRT_1_LOW_REFERENCE_OFFSET  = 28;
int const engineering_train3_telem_group::BLACKBODY_3_PRT_2_TEMPERATURE_OFFSET    = 30;
int const engineering_train3_telem_group::BLACKBODY_3_PRT_2_HIGH_REFERENCE_OFFSET = 32;
int const engineering_train3_telem_group::BLACKBODY_3_PRT_2_LOW_REFERENCE_OFFSET  = 34;
int const engineering_train3_telem_group::BLACKBODY_3_HEATER_VOLTAGE_OFFSET       = 212;
int const engineering_train3_telem_group::CHOPPER_3_TEMPERATURE_OFFSET            = 132;
int const engineering_train3_telem_group::LMC_3_GAS_TEMPERATURE_OFFSET            = 52;
int const engineering_train3_telem_group::LMC_3_PRESSURE_TEMPERATURE_OFFSET       = 168;
int const engineering_train3_telem_group::LMC_3_PRESSURE_OFFSET                   = 184;
int const engineering_train3_telem_group::LMC_3_PRESSURE_HIGH_REFERENCE_OFFSET    = 186;
int const engineering_train3_telem_group::LMC_3_PRESSURE_LOW_REFERENCE_OFFSET     = 188;
int const engineering_train3_telem_group::DETECTOR_5_TEMPERATURE_OFFSET           = 104;
int const engineering_train3_telem_group::DETECTOR_6_TEMPERATURE_OFFSET           = 106;
int const engineering_train3_telem_group::COLD_FILTER_5_TEMPERATURE_OFFSET        = 92;
int const engineering_train3_telem_group::SIEVE_3_TEMPERATURE_OFFSET              = 72;
int const engineering_train3_telem_group::SIEVE_3_HIGH_REFERENCE_OFFSET           = 74;
int const engineering_train3_telem_group::SIEVE_3_LOW_REFERENCE_OFFSET            = 76;
int const engineering_train3_telem_group::SIEVE_3_HEATER_VOLTAGE_OFFSET           = 220;
int const engineering_train3_telem_group::FIELDCOUNT                              = 20;

engineering_train3_telem_group :: engineering_train3_telem_group ()
                                : engineering_data_group ()
{
  ;
}


engineering_train3_telem_group :: ~engineering_train3_telem_group ()
{
  ;
}


void engineering_train3_telem_group :: AddBlock (unsigned char* blockdata)
{
  // make the container to hold the data we want
  unsigned short* telemdata = new unsigned short [FIELDCOUNT];

  // unpack the data
  telemdata [BLACKBODY_3_PRT_1_TEMPERATURE]    = UnpackData (&blockdata [BLACKBODY_3_PRT_1_TEMPERATURE_OFFSET]);
  telemdata [BLACKBODY_3_PRT_1_HIGH_REFERENCE] = UnpackData (&blockdata [BLACKBODY_3_PRT_1_HIGH_REFERENCE_OFFSET]);
  telemdata [BLACKBODY_3_PRT_1_LOW_REFERENCE]  = UnpackData (&blockdata [BLACKBODY_3_PRT_1_LOW_REFERENCE_OFFSET]);
  telemdata [BLACKBODY_3_PRT_2_TEMPERATURE]    = UnpackData (&blockdata [BLACKBODY_3_PRT_2_TEMPERATURE_OFFSET]);
  telemdata [BLACKBODY_3_PRT_2_HIGH_REFERENCE] = UnpackData (&blockdata [BLACKBODY_3_PRT_2_HIGH_REFERENCE_OFFSET]);
  telemdata [BLACKBODY_3_PRT_2_LOW_REFERENCE]  = UnpackData (&blockdata [BLACKBODY_3_PRT_2_LOW_REFERENCE_OFFSET]);
  telemdata [BLACKBODY_3_HEATER_VOLTAGE]       = UnpackData (&blockdata [BLACKBODY_3_HEATER_VOLTAGE_OFFSET]);
  telemdata [CHOPPER_3_TEMPERATURE]            = UnpackData (&blockdata [CHOPPER_3_TEMPERATURE_OFFSET]);
  telemdata [LMC_3_GAS_TEMPERATURE]            = UnpackData (&blockdata [LMC_3_GAS_TEMPERATURE_OFFSET]);
  telemdata [LMC_3_PRESSURE_TEMPERATURE]       = UnpackData (&blockdata [LMC_3_PRESSURE_TEMPERATURE_OFFSET]);
  telemdata [LMC_3_PRESSURE]                   = UnpackData (&blockdata [LMC_3_PRESSURE_OFFSET]);
  telemdata [LMC_3_PRESSURE_HIGH_REFERENCE]    = UnpackData (&blockdata [LMC_3_PRESSURE_HIGH_REFERENCE_OFFSET]);
  telemdata [LMC_3_PRESSURE_LOW_REFERENCE]     = UnpackData (&blockdata [LMC_3_PRESSURE_LOW_REFERENCE_OFFSET]);
  telemdata [DETECTOR_5_TEMPERATURE]           = UnpackData (&blockdata [DETECTOR_5_TEMPERATURE_OFFSET]);
  telemdata [DETECTOR_6_TEMPERATURE]           = UnpackData (&blockdata [DETECTOR_6_TEMPERATURE_OFFSET]);
  telemdata [COLD_FILTER_5_TEMPERATURE]        = UnpackData (&blockdata [COLD_FILTER_5_TEMPERATURE_OFFSET]);
  telemdata [SIEVE_3_TEMPERATURE]              = UnpackData (&blockdata [SIEVE_3_TEMPERATURE_OFFSET]);
  telemdata [SIEVE_3_HIGH_REFERENCE]           = UnpackData (&blockdata [SIEVE_3_HIGH_REFERENCE_OFFSET]);
  telemdata [SIEVE_3_LOW_REFERENCE]            = UnpackData (&blockdata [SIEVE_3_LOW_REFERENCE_OFFSET]);
  telemdata [SIEVE_3_HEATER_VOLTAGE]           = UnpackData (&blockdata [SIEVE_3_HEATER_VOLTAGE_OFFSET]);

  // add the container to the list
  datalist.AddData (telemdata);
}


bool engineering_train3_telem_group :: Define (int32 fileid, int32 groupid, string const& groupclass,
                                               string const& dataclass)
{
  string const fieldnames [FIELDCOUNT] = {"Blackbody 3 PRT 1 Temperature", "Blackbody 3 PRT 1 High Reference",
                                          "Blackbody 3 PRT 1 Low Reference", "Blackbody 3 PRT 2 Temperature",
                                          "Blackbody 3 PRT 2 High Reference", "Blackbody 3 PRT 2 Low Reference",
                                          "Blackbody 3 Heater Voltage", "Chopper 3 Temperature",
                                          "LMC 3 Gas Temperature", "LMC 3 Pressure Temperature", "LMC 3 Pressure",
                                          "LMC 3 Pressure High Reference", "LMC 3 Pressure Low Reference",
                                          "Detector 5 Temperature", "Detector 6 Temperature", 
                                          "Cold Filter 5 Temperature", "Sieve 3 Temperature", "Sieve 3 High Reference",
                                          "Sieve 3 Low Reference", "Sieve 3 Heater Voltage"};
  int32 const datatypes [FIELDCOUNT] = {DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16,
                                        DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16,
                                        DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16,
                                        DFNT_UINT16, DFNT_UINT16};
  int32 const orders [FIELDCOUNT] = {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};

  return engineering_data_group::Define (fileid, groupid, "Engineering Train3 Telem Group", groupclass,
                                         "Engineering Train3 Telem Data", dataclass, FIELDCOUNT, fieldnames, datatypes,
                                         orders);
}


float engineering_train3_telem_group :: GetEventTemperature (int startindex, int stopindex, mopip_file const& mopipfile)
{
  // get the average readings for bb1 temp, hi ref and lo ref; use mopip to convert to units
  float bb1sensor [ENGINEERING_STATES], bb1hiref [ENGINEERING_STATES], bb1loref [ENGINEERING_STATES];
  datalist.GetAverageValue ((int) BLACKBODY_3_PRT_1_TEMPERATURE,    startindex, stopindex, bb1sensor);
  datalist.GetAverageValue ((int) BLACKBODY_3_PRT_1_HIGH_REFERENCE, startindex, stopindex, bb1hiref);
  datalist.GetAverageValue ((int) BLACKBODY_3_PRT_1_LOW_REFERENCE,  startindex, stopindex, bb1loref);
  float bb1temp [ENGINEERING_STATES];
  mopipfile.Compute (BlackbodyTemperature3_1, bb1sensor, bb1hiref, bb1loref, bb1temp);

  // get the average readings for bb2 temp, hi ref and lo ref; use mopip to convert to units
  float bb2sensor [ENGINEERING_STATES], bb2hiref [ENGINEERING_STATES], bb2loref [ENGINEERING_STATES];
  datalist.GetAverageValue ((int) BLACKBODY_3_PRT_2_TEMPERATURE,    startindex, stopindex, bb2sensor);
  datalist.GetAverageValue ((int) BLACKBODY_3_PRT_2_HIGH_REFERENCE, startindex, stopindex, bb2hiref);
  datalist.GetAverageValue ((int) BLACKBODY_3_PRT_2_LOW_REFERENCE,  startindex, stopindex, bb2loref);
  float bb2temp [ENGINEERING_STATES];
  mopipfile.Compute (BlackbodyTemperature3_2, bb2sensor, bb2hiref, bb2loref, bb2temp);

  return ((bb1temp [ENGINEERING_AVERAGE_VALUE] + bb2temp [ENGINEERING_AVERAGE_VALUE]) / 2.0);
}


void engineering_train3_telem_group :: GetSummaryData (int startindex, int stopindex, mopip_file const& mopipfile, 
                                                       float diodehighrefs [DIODE_BANKS] [ENGINEERING_STATES], 
                                                       float diodelowrefs [DIODE_BANKS] [ENGINEERING_STATES], 
                                                       float thermistorhighrefs [THERMISTOR_BANKS] [ENGINEERING_STATES],
                                                       float thermistorlowrefs [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                                    float summarydata [ENGINEERING_SUMMARY_VALUES] [ENGINEERING_STATES])
{
  float sensor [ENGINEERING_STATES], highref [ENGINEERING_STATES], lowref [ENGINEERING_STATES];
  short bank;

  datalist.GetAverageValue ((int) BLACKBODY_3_PRT_1_TEMPERATURE, startindex, stopindex, sensor);
  datalist.GetAverageValue ((int) BLACKBODY_3_PRT_1_HIGH_REFERENCE, startindex, stopindex, highref);
  datalist.GetAverageValue ((int) BLACKBODY_3_PRT_1_LOW_REFERENCE,  startindex, stopindex, lowref);
  mopipfile.Compute (BlackbodyTemperature3_1, sensor, highref, lowref, summarydata[SUMMARY_BLACKBODY_3_TEMPERATURE_1]);

  datalist.GetAverageValue ((int) BLACKBODY_3_PRT_2_TEMPERATURE, startindex, stopindex, sensor);
  datalist.GetAverageValue ((int) BLACKBODY_3_PRT_2_HIGH_REFERENCE, startindex, stopindex, highref);
  datalist.GetAverageValue ((int) BLACKBODY_3_PRT_2_LOW_REFERENCE,  startindex, stopindex, lowref);
  mopipfile.Compute (BlackbodyTemperature3_2, sensor, highref, lowref, summarydata[SUMMARY_BLACKBODY_3_TEMPERATURE_2]);

  datalist.GetAverageValue ((int) BLACKBODY_3_HEATER_VOLTAGE, startindex, stopindex, sensor);
  mopipfile.Compute (BlackbodyHeaterVoltage3, sensor, summarydata[SUMMARY_BLACKBODY_3_HEATER_VOLTAGE]);

  datalist.GetAverageValue ((int) CHOPPER_3_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (ChopperTemperature3);
  mopipfile.Compute (ChopperTemperature3, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     summarydata[SUMMARY_CHOPPER_3_TEMPERATURE]);

  datalist.GetAverageValue ((int) LMC_3_GAS_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (LMCTemperature3);
  mopipfile.Compute (LMCTemperature3, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     summarydata[SUMMARY_LMC_3_TEMPERATURE]);

  datalist.GetAverageValue ((int) LMC_3_PRESSURE_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (LMCPressureTemperature3);
  mopipfile.Compute (LMCPressureTemperature3, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     summarydata[SUMMARY_LMC_3_PRESSURE_TEMPERATURE]);

  datalist.GetAverageValue ((int) LMC_3_PRESSURE,                startindex, stopindex, sensor);
  datalist.GetAverageValue ((int) LMC_3_PRESSURE_HIGH_REFERENCE, startindex, stopindex, highref);
  datalist.GetAverageValue ((int) LMC_3_PRESSURE_LOW_REFERENCE,  startindex, stopindex, lowref);
  mopipfile.Compute (LMCPressure3, sensor, highref, lowref, summarydata[SUMMARY_LMC_3_PRESSURE]);

  datalist.GetAverageValue ((int) DETECTOR_5_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (DetectorTemperature5);
  mopipfile.Compute (DetectorTemperature5, sensor, diodehighrefs[bank - 1], diodelowrefs[bank - 1],
                     summarydata[SUMMARY_DETECTOR_5_TEMPERATURE]);

  datalist.GetAverageValue ((int) DETECTOR_6_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (DetectorTemperature6);
  mopipfile.Compute (DetectorTemperature6, sensor, diodehighrefs[bank - 1], diodelowrefs[bank - 1],
                     summarydata[SUMMARY_DETECTOR_6_TEMPERATURE]);

  datalist.GetAverageValue ((int) COLD_FILTER_5_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (ColdFilterTemperature5);
  mopipfile.Compute (ColdFilterTemperature5, sensor, diodehighrefs[bank - 1], diodelowrefs[bank - 1],
                     summarydata[SUMMARY_COLD_FILTER_5_TEMPERATURE]);

  datalist.GetAverageValue ((int) SIEVE_3_TEMPERATURE, startindex, stopindex, sensor);
  datalist.GetAverageValue ((int) SIEVE_3_HIGH_REFERENCE, startindex, stopindex, highref);
  datalist.GetAverageValue ((int) SIEVE_3_LOW_REFERENCE,  startindex, stopindex, lowref);
  mopipfile.Compute (SieveTemperature3, sensor, highref, lowref, summarydata[SUMMARY_SIEVE_3_TEMPERATURE]);

  datalist.GetAverageValue ((int) SIEVE_3_HEATER_VOLTAGE, startindex, stopindex, sensor);
  mopipfile.Compute (SieveHeaterVoltage3, sensor, summarydata[SUMMARY_SIEVE_3_HEATER_VOLTAGE]);
}


void engineering_train3_telem_group :: GetSwathData (int startindex, int stopindex, mopip_file const& mopipfile, 
                                                     float diodehighrefs [DIODE_BANKS] [ENGINEERING_STATES], 
                                                     float diodelowrefs [DIODE_BANKS] [ENGINEERING_STATES], 
                                                     float thermistorhighrefs [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                                     float thermistorlowrefs [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                                     float swathdata [ENGINEERING_SWATH_VALUES] [ENGINEERING_STATES])
{
  float sensor [ENGINEERING_STATES], highref [ENGINEERING_STATES], lowref [ENGINEERING_STATES];
  short bank;

  datalist.GetAverageValue ((int) CHOPPER_3_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (ChopperTemperature3);
  mopipfile.Compute (ChopperTemperature3, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     swathdata[SWATH_CHOPPER_3_TEMPERATURE]);

  datalist.GetAverageValue ((int) COLD_FILTER_5_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (ColdFilterTemperature5);
  mopipfile.Compute (ColdFilterTemperature5, sensor, diodehighrefs[bank - 1], diodelowrefs[bank - 1],
                     swathdata[SWATH_COLDFILTER_5_TEMPERATURE]);

  datalist.GetAverageValue ((int) DETECTOR_5_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (DetectorTemperature5);
  mopipfile.Compute (DetectorTemperature5, sensor, diodehighrefs[bank - 1], diodelowrefs[bank - 1],
                     swathdata[SWATH_DETECTOR_5_TEMPERATURE]);

  datalist.GetAverageValue ((int) DETECTOR_6_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (DetectorTemperature6);
  mopipfile.Compute (DetectorTemperature6, sensor, diodehighrefs[bank - 1], diodelowrefs[bank - 1],
                     swathdata[SWATH_DETECTOR_6_TEMPERATURE]);

  datalist.GetAverageValue ((int) LMC_3_GAS_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (LMCTemperature3);
  mopipfile.Compute (LMCTemperature3, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     swathdata[SWATH_LMC_3_SHROUD_TEMPERATURE]);

  datalist.GetAverageValue ((int) LMC_3_PRESSURE_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (LMCPressureTemperature3);
  mopipfile.Compute (LMCPressureTemperature3, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     swathdata[SWATH_LMC_3_PRESSURE_TEMPERATURE]);

  datalist.GetAverageValue ((int) LMC_3_PRESSURE,                startindex, stopindex, sensor);
  datalist.GetAverageValue ((int) LMC_3_PRESSURE_HIGH_REFERENCE, startindex, stopindex, highref);
  datalist.GetAverageValue ((int) LMC_3_PRESSURE_LOW_REFERENCE,  startindex, stopindex, lowref);
  mopipfile.Compute (LMCPressure3, sensor, highref, lowref, swathdata[SWATH_LMC_3_PRESSURE]);
}
