/********** EngineeringTrain3Data.h ***********************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_ENGINEERING_TRAIN3_DATA_

  #define _MOPITT_L1_ENGINEERING_TRAIN3_DATA_

  #include "EngineeringBlock.h"
  #include "EngineeringTrain3TelemGroup.h"
  #include "EngineeringTrain3Block4Group.h"
  #include "EngineeringTrain3Block5Group.h"

  class engineering_train3_data {
    private :
      engineering_train3_telem_group  telemgroup;
      engineering_train3_block4_group block4group;
      engineering_train3_block5_group block5group;
      hdf_vgroup                      vgroup;

    protected :

    public :
      engineering_train3_data ();
      ~engineering_train3_data ();

      void  AddBlock             (engineering_block*);
      bool  Close                ();
      bool  Define               (int32, int32, string const&);
      float GetEventTemperature  (int, int, mopip_file const&);
      void  GetTelemSummaryData  (int, int, mopip_file const&, float [DIODE_BANKS] [ENGINEERING_STATES], 
                                  float [DIODE_BANKS] [ENGINEERING_STATES], 
                                  float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                  float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                  float [ENGINEERING_SUMMARY_VALUES][ENGINEERING_STATES]);
      void  GetBlock4SummaryData (int, int, mopip_file const&, float [ENGINEERING_SUMMARY_VALUES][ENGINEERING_STATES]);
      void  GetBlock5SummaryData (int, int, mopip_file const&, float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                  float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                  float [ENGINEERING_SUMMARY_VALUES][ENGINEERING_STATES]);
      void  GetSwathData         (int, int, mopip_file const&, float [DIODE_BANKS] [ENGINEERING_STATES], 
                                  float [DIODE_BANKS] [ENGINEERING_STATES], 
                                  float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                  float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                  float [ENGINEERING_SWATH_VALUES][ENGINEERING_STATES]);
      bool  Write                ();
  };

#endif
