/********** EngineeringTrain3Block4Group.C ****************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "EngineeringTrain3Block4Group.h"

int const engineering_train3_block4_group::MIRROR_3_MOTOR_CURRENT_OFFSET  = 14;
int const engineering_train3_block4_group::CHOPPER_3_MOTOR_CURRENT_OFFSET = 22;
int const engineering_train3_block4_group::LMC_3_MOTOR_CURRENT_OFFSET     = 30;
int const engineering_train3_block4_group::FIELDCOUNT                     = 3;

engineering_train3_block4_group :: engineering_train3_block4_group ()
                                 : engineering_data_group ()
{
  ;
}


engineering_train3_block4_group :: ~engineering_train3_block4_group ()
{
  ;
}


void engineering_train3_block4_group :: AddBlock (unsigned char* blockdata)
{
  // make the container to hold the data we want
  unsigned short* housedata = new unsigned short [FIELDCOUNT];

  // unpack the data
  housedata [MIRROR_3_MOTOR_CURRENT]  = UnpackData (&blockdata [MIRROR_3_MOTOR_CURRENT_OFFSET]);
  housedata [CHOPPER_3_MOTOR_CURRENT] = UnpackData (&blockdata [CHOPPER_3_MOTOR_CURRENT_OFFSET]);
  housedata [LMC_3_MOTOR_CURRENT]     = UnpackData (&blockdata [LMC_3_MOTOR_CURRENT_OFFSET]);

  // add the container to the list
  datalist.AddData (housedata);
}


bool engineering_train3_block4_group :: Define (int32 fileid, int32 groupid, string const& groupclass,
                                                string const& dataclass)
{
  string const fieldnames [FIELDCOUNT] = {"Mirror 3 Motor Current", "Chopper 3 Motor Current", "LMC 3 Motor Current"};
  int32 const datatypes [FIELDCOUNT] = {DFNT_UINT16, DFNT_UINT16, DFNT_UINT16};
  int32 const orders [FIELDCOUNT] = {1, 1, 1};

  return engineering_data_group::Define (fileid, groupid, "Engineering Train3 Block4 Group", groupclass,
                                         "Engineering Train3 Block4 Data", dataclass, FIELDCOUNT, fieldnames, 
                                         datatypes, orders);
}


void engineering_train3_block4_group :: GetSummaryData (int startindex, int stopindex, mopip_file const& mopipfile, 
                                                    float summarydata [ENGINEERING_SUMMARY_VALUES] [ENGINEERING_STATES])
{
  float sensor [ENGINEERING_STATES];

  datalist.GetAverageValue ((int) MIRROR_3_MOTOR_CURRENT, startindex, stopindex, sensor);
  mopipfile.Compute (MirrorMotorCurrent3, sensor, summarydata[SUMMARY_MIRROR_3_MOTOR_CURRENT]);

  datalist.GetAverageValue ((int) CHOPPER_3_MOTOR_CURRENT, startindex, stopindex, sensor);
  mopipfile.Compute (ChopperMotorCurrent3, sensor, summarydata[SUMMARY_CHOPPER_3_MOTOR_CURRENT]);

  datalist.GetAverageValue ((int) LMC_3_MOTOR_CURRENT, startindex, stopindex, sensor);
  mopipfile.Compute (LMCMotorCurrent3, sensor, summarydata[SUMMARY_LMC_3_MOTOR_CURRENT]);
}
