/********** EngineeringTrain2TelemGroup.h *****************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh
   02/00   Tom Lauren

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_ENGINEERING_TRAIN2_TELEM_GROUP_

  #define _MOPITT_L1_ENGINEERING_TRAIN2_TELEM_GROUP_

  #include "EngineeringDataConstants.h"
  #include "EngineeringDataGroup.h"
  #include "MOPIPFile.h"

  class engineering_train2_telem_group : public engineering_data_group {
    private :
      static int const BLACKBODY_2_PRT_1_TEMPERATURE_OFFSET;
      static int const BLACKBODY_2_PRT_1_HIGH_REFERENCE_OFFSET;
      static int const BLACKBODY_2_PRT_1_LOW_REFERENCE_OFFSET;
      static int const BLACKBODY_2_PRT_2_TEMPERATURE_OFFSET;
      static int const BLACKBODY_2_PRT_2_HIGH_REFERENCE_OFFSET;
      static int const BLACKBODY_2_PRT_2_LOW_REFERENCE_OFFSET;
      static int const BLACKBODY_2_HEATER_VOLTAGE_OFFSET;
      static int const CHOPPER_2_TEMPERATURE_OFFSET;
      static int const LMC_2_GAS_TEMPERATURE_OFFSET;
      static int const LMC_2_PRESSURE_TEMPERATURE_OFFSET;
      static int const LMC_2_PRESSURE_OFFSET;
      static int const LMC_2_PRESSURE_HIGH_REFERENCE_OFFSET;
      static int const LMC_2_PRESSURE_LOW_REFERENCE_OFFSET;
      static int const DETECTOR_3_TEMPERATURE_OFFSET;
      static int const DETECTOR_4_TEMPERATURE_OFFSET;
      static int const COLD_FILTER_3_TEMPERATURE_OFFSET;
      static int const SIEVE_2_TEMPERATURE_OFFSET;
      static int const SIEVE_2_HIGH_REFERENCE_OFFSET;
      static int const SIEVE_2_LOW_REFERENCE_OFFSET;
      static int const SIEVE_2_HEATER_VOLTAGE_OFFSET;
      static int const PMC_1_GAS_TEMPERATURE_OFFSET;
      static int const PMC_1_PICKOFF_AMPLITUDE_OFFSET;
      static int const PMC_1_PHASE_ERROR_OFFSET;
      static int const FIELDCOUNT;

      enum engineering_train2_telem_sensor { BLACKBODY_2_PRT_1_TEMPERATURE,    BLACKBODY_2_PRT_1_HIGH_REFERENCE,
                                             BLACKBODY_2_PRT_1_LOW_REFERENCE,  BLACKBODY_2_PRT_2_TEMPERATURE,
                                             BLACKBODY_2_PRT_2_HIGH_REFERENCE, BLACKBODY_2_PRT_2_LOW_REFERENCE,
                                             BLACKBODY_2_HEATER_VOLTAGE,       
                                             CHOPPER_2_TEMPERATURE,            LMC_2_GAS_TEMPERATURE,
                                             LMC_2_PRESSURE_TEMPERATURE,       LMC_2_PRESSURE,
                                             LMC_2_PRESSURE_HIGH_REFERENCE,    LMC_2_PRESSURE_LOW_REFERENCE,
                                             DETECTOR_3_TEMPERATURE,           DETECTOR_4_TEMPERATURE,
                                             COLD_FILTER_3_TEMPERATURE,        SIEVE_2_TEMPERATURE,
                                             SIEVE_2_HIGH_REFERENCE,           SIEVE_2_LOW_REFERENCE,
                                             SIEVE_2_HEATER_VOLTAGE,           PMC_1_GAS_TEMPERATURE,
                                             PMC_1_PICKOFF_AMPLITUDE,          PMC_1_PHASE_ERROR };

    protected :

    public :
      engineering_train2_telem_group ();
      ~engineering_train2_telem_group ();

      void  AddBlock            (unsigned char*);
      bool  Define              (int32, int32, string const&, string const&);
      float GetEventTemperature (int, int, mopip_file const&);
      void  GetSummaryData      (int, int, mopip_file const&, float [DIODE_BANKS] [ENGINEERING_STATES], 
                                 float [DIODE_BANKS] [ENGINEERING_STATES], 
                                 float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                 float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                 float [ENGINEERING_SUMMARY_VALUES] [ENGINEERING_STATES]);
      void  GetSwathData        (int, int, mopip_file const&, float [DIODE_BANKS] [ENGINEERING_STATES], 
                                 float [DIODE_BANKS] [ENGINEERING_STATES], 
                                 float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                 float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                 float [ENGINEERING_SWATH_VALUES] [ENGINEERING_STATES]);
  };

#endif
