/********** EngineeringTrain2TelemGroup.C *****************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh
   02/00   Tom Lauren

 $Log$

\**********************************************************************************************************************/

#include "EngineeringTrain2TelemGroup.h"

int const engineering_train2_telem_group::BLACKBODY_2_PRT_1_TEMPERATURE_OFFSET    = 12;
int const engineering_train2_telem_group::BLACKBODY_2_PRT_1_HIGH_REFERENCE_OFFSET = 14;
int const engineering_train2_telem_group::BLACKBODY_2_PRT_1_LOW_REFERENCE_OFFSET  = 16;
int const engineering_train2_telem_group::BLACKBODY_2_PRT_2_TEMPERATURE_OFFSET    = 18;
int const engineering_train2_telem_group::BLACKBODY_2_PRT_2_HIGH_REFERENCE_OFFSET = 20;
int const engineering_train2_telem_group::BLACKBODY_2_PRT_2_LOW_REFERENCE_OFFSET  = 22;
int const engineering_train2_telem_group::BLACKBODY_2_HEATER_VOLTAGE_OFFSET       = 210;
int const engineering_train2_telem_group::CHOPPER_2_TEMPERATURE_OFFSET            = 130;
int const engineering_train2_telem_group::LMC_2_GAS_TEMPERATURE_OFFSET            = 50;
int const engineering_train2_telem_group::LMC_2_PRESSURE_TEMPERATURE_OFFSET       = 166;
int const engineering_train2_telem_group::LMC_2_PRESSURE_OFFSET                   = 178;
int const engineering_train2_telem_group::LMC_2_PRESSURE_HIGH_REFERENCE_OFFSET    = 180;
int const engineering_train2_telem_group::LMC_2_PRESSURE_LOW_REFERENCE_OFFSET     = 182;
int const engineering_train2_telem_group::DETECTOR_3_TEMPERATURE_OFFSET           = 100;
int const engineering_train2_telem_group::DETECTOR_4_TEMPERATURE_OFFSET           = 102;
int const engineering_train2_telem_group::COLD_FILTER_3_TEMPERATURE_OFFSET        = 90;
int const engineering_train2_telem_group::SIEVE_2_TEMPERATURE_OFFSET              = 66;
int const engineering_train2_telem_group::SIEVE_2_HIGH_REFERENCE_OFFSET           = 68;
int const engineering_train2_telem_group::SIEVE_2_LOW_REFERENCE_OFFSET            = 70;
int const engineering_train2_telem_group::SIEVE_2_HEATER_VOLTAGE_OFFSET           = 218;
int const engineering_train2_telem_group::PMC_1_GAS_TEMPERATURE_OFFSET            = 56;
int const engineering_train2_telem_group::PMC_1_PICKOFF_AMPLITUDE_OFFSET          = 196;
int const engineering_train2_telem_group::PMC_1_PHASE_ERROR_OFFSET                = 200;
int const engineering_train2_telem_group::FIELDCOUNT                              = 23;

engineering_train2_telem_group :: engineering_train2_telem_group ()
                                : engineering_data_group ()
{
  ;
}


engineering_train2_telem_group :: ~engineering_train2_telem_group ()
{
  ;
}


void engineering_train2_telem_group :: AddBlock (unsigned char* blockdata)
{
  // make the container to hold the data we want
  unsigned short* telemdata = new unsigned short [FIELDCOUNT];

  // unpack the data
  telemdata [BLACKBODY_2_PRT_1_TEMPERATURE]    = UnpackData (&blockdata [BLACKBODY_2_PRT_1_TEMPERATURE_OFFSET]);
  telemdata [BLACKBODY_2_PRT_1_HIGH_REFERENCE] = UnpackData (&blockdata [BLACKBODY_2_PRT_1_HIGH_REFERENCE_OFFSET]);
  telemdata [BLACKBODY_2_PRT_1_LOW_REFERENCE]  = UnpackData (&blockdata [BLACKBODY_2_PRT_1_LOW_REFERENCE_OFFSET]);
  telemdata [BLACKBODY_2_PRT_2_TEMPERATURE]    = UnpackData (&blockdata [BLACKBODY_2_PRT_2_TEMPERATURE_OFFSET]);
  telemdata [BLACKBODY_2_PRT_2_HIGH_REFERENCE] = UnpackData (&blockdata [BLACKBODY_2_PRT_2_HIGH_REFERENCE_OFFSET]);
  telemdata [BLACKBODY_2_PRT_2_LOW_REFERENCE]  = UnpackData (&blockdata [BLACKBODY_2_PRT_2_LOW_REFERENCE_OFFSET]);
  telemdata [BLACKBODY_2_HEATER_VOLTAGE]       = UnpackData (&blockdata [BLACKBODY_2_HEATER_VOLTAGE_OFFSET]);
  telemdata [CHOPPER_2_TEMPERATURE]            = UnpackData (&blockdata [CHOPPER_2_TEMPERATURE_OFFSET]);
  telemdata [LMC_2_GAS_TEMPERATURE]            = UnpackData (&blockdata [LMC_2_GAS_TEMPERATURE_OFFSET]);
  telemdata [LMC_2_PRESSURE_TEMPERATURE]       = UnpackData (&blockdata [LMC_2_PRESSURE_TEMPERATURE_OFFSET]);
  telemdata [LMC_2_PRESSURE]                   = UnpackData (&blockdata [LMC_2_PRESSURE_OFFSET]);
  telemdata [LMC_2_PRESSURE_HIGH_REFERENCE]    = UnpackData (&blockdata [LMC_2_PRESSURE_HIGH_REFERENCE_OFFSET]);
  telemdata [LMC_2_PRESSURE_LOW_REFERENCE]     = UnpackData (&blockdata [LMC_2_PRESSURE_LOW_REFERENCE_OFFSET]);
  telemdata [DETECTOR_3_TEMPERATURE]           = UnpackData (&blockdata [DETECTOR_3_TEMPERATURE_OFFSET]);
  telemdata [DETECTOR_4_TEMPERATURE]           = UnpackData (&blockdata [DETECTOR_4_TEMPERATURE_OFFSET]);
  telemdata [COLD_FILTER_3_TEMPERATURE]        = UnpackData (&blockdata [COLD_FILTER_3_TEMPERATURE_OFFSET]);
  telemdata [SIEVE_2_TEMPERATURE]              = UnpackData (&blockdata [SIEVE_2_TEMPERATURE_OFFSET]);
  telemdata [SIEVE_2_HIGH_REFERENCE]           = UnpackData (&blockdata [SIEVE_2_HIGH_REFERENCE_OFFSET]);
  telemdata [SIEVE_2_LOW_REFERENCE]            = UnpackData (&blockdata [SIEVE_2_LOW_REFERENCE_OFFSET]);
  telemdata [SIEVE_2_HEATER_VOLTAGE]           = UnpackData (&blockdata [SIEVE_2_HEATER_VOLTAGE_OFFSET]);
  telemdata [PMC_1_GAS_TEMPERATURE]            = UnpackData (&blockdata [PMC_1_GAS_TEMPERATURE_OFFSET]);
  telemdata [PMC_1_PICKOFF_AMPLITUDE]          = UnpackData (&blockdata [PMC_1_PICKOFF_AMPLITUDE_OFFSET]);
  telemdata [PMC_1_PHASE_ERROR]                = UnpackData (&blockdata [PMC_1_PHASE_ERROR_OFFSET]);

  // add the container to the list
  datalist.AddData (telemdata);
}


bool engineering_train2_telem_group :: Define (int32 fileid, int32 groupid, string const& groupclass,
                                               string const& dataclass)
{
  string const fieldnames [FIELDCOUNT] = {"Blackbody 2 PRT 1 Temperature", "Blackbody 2 PRT 1 High Reference",
                                          "Blackbody 2 PRT 1 Low Reference", "Blackbody 2 PRT 2 Temperature",
                                          "Blackbody 2 PRT 2 High Reference", "Blackbody 2 PRT 2 Low Reference",
                                          "Blackbody 2 Heater Voltage", "Chopper 2 Temperature",
                                          "LMC 2 Gas Temperature", "LMC 2 Pressure Temperature", "LMC 2 Pressure",
                                          "LMC 2 Pressure High Reference", "LMC 2 Pressure Low Reference",
                                          "Detector 3 Temperature", "Detector 4 Temperature", 
                                          "Cold Filter 3 Temperature", "Sieve 2 Temperature", "Sieve 2 High Reference",
                                          "Sieve 2 Low Reference", "Sieve 2 Heater Voltage", "PMC 1 Gas Temperature",
                                          "PMC 1 Pickoff Amplitude", "PMC 1 Phase Error"};
  int32 const datatypes [FIELDCOUNT] = {DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16,
                                        DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16,
                                        DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16,
                                        DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16};
  int32 const orders [FIELDCOUNT] = {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};

  return engineering_data_group::Define (fileid, groupid, "Engineering Train2 Telem Group", groupclass,
                                         "Engineering Train2 Telem Data", dataclass, FIELDCOUNT, fieldnames, datatypes,
                                         orders);
}


float engineering_train2_telem_group :: GetEventTemperature (int startindex, int stopindex, mopip_file const& mopipfile)
{
  // get the average readings for bb1 temp, hi ref and lo ref; use mopip to convert to units
  float bb1sensor [ENGINEERING_STATES], bb1hiref [ENGINEERING_STATES], bb1loref [ENGINEERING_STATES];
  datalist.GetAverageValue ((int) BLACKBODY_2_PRT_1_TEMPERATURE,    startindex, stopindex, bb1sensor);
  datalist.GetAverageValue ((int) BLACKBODY_2_PRT_1_HIGH_REFERENCE, startindex, stopindex, bb1hiref);
  datalist.GetAverageValue ((int) BLACKBODY_2_PRT_1_LOW_REFERENCE,  startindex, stopindex, bb1loref);
  float bb1temp [ENGINEERING_STATES];
  mopipfile.Compute (BlackbodyTemperature2_1, bb1sensor, bb1hiref, bb1loref, bb1temp);

  // get the average readings for bb2 temp, hi ref and lo ref; use mopip to convert to units
  float bb2sensor [ENGINEERING_STATES], bb2hiref [ENGINEERING_STATES], bb2loref [ENGINEERING_STATES];
  datalist.GetAverageValue ((int) BLACKBODY_2_PRT_2_TEMPERATURE,    startindex, stopindex, bb2sensor);
  datalist.GetAverageValue ((int) BLACKBODY_2_PRT_2_HIGH_REFERENCE, startindex, stopindex, bb2hiref);
  datalist.GetAverageValue ((int) BLACKBODY_2_PRT_2_LOW_REFERENCE,  startindex, stopindex, bb2loref);
  float bb2temp [ENGINEERING_STATES];
  mopipfile.Compute (BlackbodyTemperature2_2, bb2sensor, bb2hiref, bb2loref, bb2temp);

  return ((bb1temp [ENGINEERING_AVERAGE_VALUE] + bb2temp [ENGINEERING_AVERAGE_VALUE]) / 2.0);
}


void engineering_train2_telem_group :: GetSummaryData (int startindex, int stopindex, mopip_file const& mopipfile, 
                                                       float diodehighrefs [DIODE_BANKS] [ENGINEERING_STATES], 
                                                       float diodelowrefs [DIODE_BANKS] [ENGINEERING_STATES], 
                                                       float thermistorhighrefs [THERMISTOR_BANKS] [ENGINEERING_STATES],
                                                       float thermistorlowrefs [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                                    float summarydata [ENGINEERING_SUMMARY_VALUES] [ENGINEERING_STATES])
{
  float sensor [ENGINEERING_STATES], highref [ENGINEERING_STATES], lowref [ENGINEERING_STATES];
  short bank;

  datalist.GetAverageValue ((int) BLACKBODY_2_PRT_1_TEMPERATURE, startindex, stopindex, sensor);
  datalist.GetAverageValue ((int) BLACKBODY_2_PRT_1_HIGH_REFERENCE, startindex, stopindex, highref);
  datalist.GetAverageValue ((int) BLACKBODY_2_PRT_1_LOW_REFERENCE,  startindex, stopindex, lowref);
  mopipfile.Compute (BlackbodyTemperature2_1, sensor, highref, lowref, summarydata[SUMMARY_BLACKBODY_2_TEMPERATURE_1]);

  datalist.GetAverageValue ((int) BLACKBODY_2_PRT_2_TEMPERATURE, startindex, stopindex, sensor);
  datalist.GetAverageValue ((int) BLACKBODY_2_PRT_2_HIGH_REFERENCE, startindex, stopindex, highref);
  datalist.GetAverageValue ((int) BLACKBODY_2_PRT_2_LOW_REFERENCE,  startindex, stopindex, lowref);
  mopipfile.Compute (BlackbodyTemperature2_2, sensor, highref, lowref, summarydata[SUMMARY_BLACKBODY_2_TEMPERATURE_2]);

  datalist.GetAverageValue ((int) BLACKBODY_2_HEATER_VOLTAGE, startindex, stopindex, sensor);
  mopipfile.Compute (BlackbodyHeaterVoltage2, sensor, summarydata[SUMMARY_BLACKBODY_2_HEATER_VOLTAGE]);

  datalist.GetAverageValue ((int) CHOPPER_2_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (ChopperTemperature2);
  mopipfile.Compute (ChopperTemperature2, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     summarydata[SUMMARY_CHOPPER_2_TEMPERATURE]);

  datalist.GetAverageValue ((int) LMC_2_GAS_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (LMCTemperature2);
  mopipfile.Compute (LMCTemperature2, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     summarydata[SUMMARY_LMC_2_TEMPERATURE]);

  datalist.GetAverageValue ((int) LMC_2_PRESSURE_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (LMCPressureTemperature2);
  mopipfile.Compute (LMCPressureTemperature2, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     summarydata[SUMMARY_LMC_2_PRESSURE_TEMPERATURE]);

  datalist.GetAverageValue ((int) LMC_2_PRESSURE,                startindex, stopindex, sensor);
  datalist.GetAverageValue ((int) LMC_2_PRESSURE_HIGH_REFERENCE, startindex, stopindex, highref);
  datalist.GetAverageValue ((int) LMC_2_PRESSURE_LOW_REFERENCE,  startindex, stopindex, lowref);
  mopipfile.Compute (LMCPressure2, sensor, highref, lowref, summarydata[SUMMARY_LMC_2_PRESSURE]);

  datalist.GetAverageValue ((int) DETECTOR_3_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (DetectorTemperature3);
  mopipfile.Compute (DetectorTemperature3, sensor, diodehighrefs[bank - 1], diodelowrefs[bank - 1],
                     summarydata[SUMMARY_DETECTOR_3_TEMPERATURE]);

  datalist.GetAverageValue ((int) DETECTOR_4_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (DetectorTemperature4);
  mopipfile.Compute (DetectorTemperature4, sensor, diodehighrefs[bank - 1], diodelowrefs[bank - 1],
                     summarydata[SUMMARY_DETECTOR_4_TEMPERATURE]);

  datalist.GetAverageValue ((int) COLD_FILTER_3_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (ColdFilterTemperature3);
  mopipfile.Compute (ColdFilterTemperature3, sensor, diodehighrefs[bank - 1], diodelowrefs[bank - 1],
                     summarydata[SUMMARY_COLD_FILTER_3_TEMPERATURE]);

  datalist.GetAverageValue ((int) SIEVE_2_TEMPERATURE, startindex, stopindex, sensor);
  datalist.GetAverageValue ((int) SIEVE_2_HIGH_REFERENCE, startindex, stopindex, highref);
  datalist.GetAverageValue ((int) SIEVE_2_LOW_REFERENCE,  startindex, stopindex, lowref);
  mopipfile.Compute (SieveTemperature2, sensor, highref, lowref, summarydata[SUMMARY_SIEVE_2_TEMPERATURE]);

  datalist.GetAverageValue ((int) SIEVE_2_HEATER_VOLTAGE, startindex, stopindex, sensor);
  mopipfile.Compute (SieveHeaterVoltage2, sensor, summarydata[SUMMARY_SIEVE_2_HEATER_VOLTAGE]);

  datalist.GetAverageValue ((int) PMC_1_GAS_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (PMCTemperature1);
  mopipfile.Compute (PMCTemperature1, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     summarydata[SUMMARY_PMC_1_TEMPERATURE]);

  datalist.GetAverageValue ((int) PMC_1_PICKOFF_AMPLITUDE, startindex, stopindex, sensor);
  mopipfile.Compute (PMCAmplitude1, sensor, summarydata[SUMMARY_PMC_1_AMPLITUDE]);

  datalist.GetAverageValue ((int) PMC_1_PHASE_ERROR, startindex, stopindex, sensor);
  mopipfile.Compute (PMCPhaseError1, sensor, summarydata[SUMMARY_PMC_1_PHASE_ERROR]);
}


void engineering_train2_telem_group :: GetSwathData (int startindex, int stopindex, mopip_file const& mopipfile, 
                                                     float diodehighrefs [DIODE_BANKS] [ENGINEERING_STATES], 
                                                     float diodelowrefs [DIODE_BANKS] [ENGINEERING_STATES], 
                                                     float thermistorhighrefs [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                                     float thermistorlowrefs [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                                     float swathdata [ENGINEERING_SWATH_VALUES] [ENGINEERING_STATES])
{
  float sensor [ENGINEERING_STATES], highref [ENGINEERING_STATES], lowref [ENGINEERING_STATES];
  short bank;

  datalist.GetAverageValue ((int) CHOPPER_2_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (ChopperTemperature2);
  mopipfile.Compute (ChopperTemperature2, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     swathdata[SWATH_CHOPPER_2_TEMPERATURE]);

  datalist.GetAverageValue ((int) COLD_FILTER_3_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (ColdFilterTemperature3);
  mopipfile.Compute (ColdFilterTemperature3, sensor, diodehighrefs[bank - 1], diodelowrefs[bank - 1],
                     swathdata[SWATH_COLDFILTER_3_TEMPERATURE]);

  datalist.GetAverageValue ((int) DETECTOR_3_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (DetectorTemperature3);
  mopipfile.Compute (DetectorTemperature3, sensor, diodehighrefs[bank - 1], diodelowrefs[bank - 1],
                     swathdata[SWATH_DETECTOR_3_TEMPERATURE]);

  datalist.GetAverageValue ((int) DETECTOR_4_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (DetectorTemperature4);
  mopipfile.Compute (DetectorTemperature4, sensor, diodehighrefs[bank - 1], diodelowrefs[bank - 1],
                     swathdata[SWATH_DETECTOR_4_TEMPERATURE]);

  datalist.GetAverageValue ((int) LMC_2_GAS_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (LMCTemperature2);
  mopipfile.Compute (LMCTemperature2, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     swathdata[SWATH_LMC_2_SHROUD_TEMPERATURE]);

  datalist.GetAverageValue ((int) LMC_2_PRESSURE_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (LMCPressureTemperature2);
  mopipfile.Compute (LMCPressureTemperature2, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     swathdata[SWATH_LMC_2_PRESSURE_TEMPERATURE]);

  datalist.GetAverageValue ((int) LMC_2_PRESSURE,                startindex, stopindex, sensor);
  datalist.GetAverageValue ((int) LMC_2_PRESSURE_HIGH_REFERENCE, startindex, stopindex, highref);
  datalist.GetAverageValue ((int) LMC_2_PRESSURE_LOW_REFERENCE,  startindex, stopindex, lowref);
  mopipfile.Compute (LMCPressure2, sensor, highref, lowref, swathdata[SWATH_LMC_2_PRESSURE]);

  datalist.GetAverageValue ((int) PMC_1_GAS_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (PMCTemperature1);
  mopipfile.Compute (PMCTemperature1, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     swathdata[SWATH_PMC_1_SHROUD_TEMPERATURE]);

  swathdata [SWATH_PMC_1_HIGH_STROKE_PRESSURE] [ENGINEERING_AVERAGE_VALUE] = ENGINEERING_MISSING_VALUE;
  swathdata [SWATH_PMC_1_HIGH_STROKE_PRESSURE] [ENGINEERING_VARIANCE_VALUE] = ENGINEERING_MISSING_VALUE;
  swathdata [SWATH_PMC_1_LOW_STROKE_PRESSURE]  [ENGINEERING_AVERAGE_VALUE] = ENGINEERING_MISSING_VALUE;
  swathdata [SWATH_PMC_1_LOW_STROKE_PRESSURE]  [ENGINEERING_VARIANCE_VALUE] = ENGINEERING_MISSING_VALUE;
}
