/********** EngineeringTrain2Block4Group.C ****************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "EngineeringTrain2Block4Group.h"

int const engineering_train2_block4_group::MIRROR_2_MOTOR_CURRENT_OFFSET  = 12;
int const engineering_train2_block4_group::CHOPPER_2_MOTOR_CURRENT_OFFSET = 20;
int const engineering_train2_block4_group::LMC_2_MOTOR_CURRENT_OFFSET     = 28;
int const engineering_train2_block4_group::PMC_1_MOTOR_CURRENT_OFFSET     = 34;
int const engineering_train2_block4_group::FIELDCOUNT                     = 4;

engineering_train2_block4_group :: engineering_train2_block4_group ()
                                 : engineering_data_group ()
{
  ;
}


engineering_train2_block4_group :: ~engineering_train2_block4_group ()
{
  ;
}


void engineering_train2_block4_group :: AddBlock (unsigned char* blockdata)
{
  // make the container to hold the data we want
  unsigned short* housedata = new unsigned short [FIELDCOUNT];

  // unpack the data
  housedata [MIRROR_2_MOTOR_CURRENT]  = UnpackData (&blockdata [MIRROR_2_MOTOR_CURRENT_OFFSET]);
  housedata [CHOPPER_2_MOTOR_CURRENT] = UnpackData (&blockdata [CHOPPER_2_MOTOR_CURRENT_OFFSET]);
  housedata [LMC_2_MOTOR_CURRENT]     = UnpackData (&blockdata [LMC_2_MOTOR_CURRENT_OFFSET]);
  housedata [PMC_1_MOTOR_CURRENT]     = UnpackData (&blockdata [PMC_1_MOTOR_CURRENT_OFFSET]);

  // add the container to the list
  datalist.AddData (housedata);
}


bool engineering_train2_block4_group :: Define (int32 fileid, int32 groupid, string const& groupclass,
                                                string const& dataclass)
{
  string const fieldnames [FIELDCOUNT] = {"Mirror 2 Motor Current", "Chopper 2 Motor Current", "LMC 2 Motor Current",
                                          "PMC 1 Motor Current"};
  int32 const datatypes [FIELDCOUNT] = {DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16};
  int32 const orders [FIELDCOUNT] = {1, 1, 1, 1};

  return engineering_data_group::Define (fileid, groupid, "Engineering Train2 Block4 Group", groupclass,
                                         "Engineering Train2 Block4 Data", dataclass, FIELDCOUNT, fieldnames, 
                                         datatypes, orders);
}


void engineering_train2_block4_group :: GetSummaryData (int startindex, int stopindex, mopip_file const& mopipfile, 
                                                    float summarydata [ENGINEERING_SUMMARY_VALUES] [ENGINEERING_STATES])
{
  float sensor [ENGINEERING_STATES];

  datalist.GetAverageValue ((int) MIRROR_2_MOTOR_CURRENT, startindex, stopindex, sensor);
  mopipfile.Compute (MirrorMotorCurrent2, sensor, summarydata[SUMMARY_MIRROR_2_MOTOR_CURRENT]);

  datalist.GetAverageValue ((int) CHOPPER_2_MOTOR_CURRENT, startindex, stopindex, sensor);
  mopipfile.Compute (ChopperMotorCurrent2, sensor, summarydata[SUMMARY_CHOPPER_2_MOTOR_CURRENT]);

  datalist.GetAverageValue ((int) LMC_2_MOTOR_CURRENT, startindex, stopindex, sensor);
  mopipfile.Compute (LMCMotorCurrent2, sensor, summarydata[SUMMARY_LMC_2_MOTOR_CURRENT]);

  datalist.GetAverageValue ((int) PMC_1_MOTOR_CURRENT, startindex, stopindex, sensor);
  mopipfile.Compute (PMCMotorCurrent1, sensor, summarydata[SUMMARY_PMC_1_MOTOR_CURRENT]);
}
