/********** EngineeringTrain1TelemGroup.h *****************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh
   02/00   Tom Lauren

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_ENGINEERING_TRAIN1_TELEM_GROUP_

  #define _MOPITT_L1_ENGINEERING_TRAIN1_TELEM_GROUP_

  #include "EngineeringDataConstants.h"
  #include "EngineeringDataGroup.h"
  #include "MOPIPFile.h"

  class engineering_train1_telem_group : public engineering_data_group {
    private :
      static int const BLACKBODY_1_PRT_1_TEMPERATURE_OFFSET;
      static int const BLACKBODY_1_PRT_1_HIGH_REFERENCE_OFFSET;
      static int const BLACKBODY_1_PRT_1_LOW_REFERENCE_OFFSET;
      static int const BLACKBODY_1_PRT_2_TEMPERATURE_OFFSET;
      static int const BLACKBODY_1_PRT_2_HIGH_REFERENCE_OFFSET;
      static int const BLACKBODY_1_PRT_2_LOW_REFERENCE_OFFSET;
      static int const BLACKBODY_1_HEATER_VOLTAGE_OFFSET;
      static int const CHOPPER_1_TEMPERATURE_OFFSET;
      static int const LMC_1_GAS_TEMPERATURE_OFFSET;
      static int const LMC_1_PRESSURE_TEMPERATURE_OFFSET;
      static int const LMC_1_PRESSURE_OFFSET;
      static int const LMC_1_PRESSURE_HIGH_REFERENCE_OFFSET;
      static int const LMC_1_PRESSURE_LOW_REFERENCE_OFFSET;
      static int const DETECTOR_1_TEMPERATURE_OFFSET;
      static int const DETECTOR_2_TEMPERATURE_OFFSET;
      static int const COLD_FILTER_1_TEMPERATURE_OFFSET;
      static int const SIEVE_1_TEMPERATURE_OFFSET;
      static int const SIEVE_1_HIGH_REFERENCE_OFFSET;
      static int const SIEVE_1_LOW_REFERENCE_OFFSET;
      static int const SIEVE_1_HEATER_VOLTAGE_OFFSET;
      static int const FIELDCOUNT;

      enum engineering_train1_telem_sensor { BLACKBODY_1_PRT_1_TEMPERATURE,    BLACKBODY_1_PRT_1_HIGH_REFERENCE,
                                             BLACKBODY_1_PRT_1_LOW_REFERENCE,  BLACKBODY_1_PRT_2_TEMPERATURE,
                                             BLACKBODY_1_PRT_2_HIGH_REFERENCE, BLACKBODY_1_PRT_2_LOW_REFERENCE,
                                             BLACKBODY_1_HEATER_VOLTAGE,       
                                             CHOPPER_1_TEMPERATURE,            LMC_1_GAS_TEMPERATURE,
                                             LMC_1_PRESSURE_TEMPERATURE,       LMC_1_PRESSURE,
                                             LMC_1_PRESSURE_HIGH_REFERENCE,    LMC_1_PRESSURE_LOW_REFERENCE,
                                             DETECTOR_1_TEMPERATURE,           DETECTOR_2_TEMPERATURE,
                                             COLD_FILTER_1_TEMPERATURE,        SIEVE_1_TEMPERATURE,
                                             SIEVE_1_HIGH_REFERENCE,           SIEVE_1_LOW_REFERENCE,
                                             SIEVE_1_HEATER_VOLTAGE };

    protected :

    public :
      engineering_train1_telem_group ();
      ~engineering_train1_telem_group ();

      void  AddBlock            (unsigned char*);
      bool  Define              (int32, int32, string const&, string const&);
      float GetEventTemperature (int, int, mopip_file const&);
      void  GetSummaryData      (int, int, mopip_file const&, float [DIODE_BANKS] [ENGINEERING_STATES], 
                                 float [DIODE_BANKS] [ENGINEERING_STATES], 
                                 float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                 float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                 float [ENGINEERING_SUMMARY_VALUES] [ENGINEERING_STATES]);
      void  GetSwathData        (int, int, mopip_file const&, float [DIODE_BANKS] [ENGINEERING_STATES], 
                                 float [DIODE_BANKS] [ENGINEERING_STATES], 
                                 float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                 float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                 float [ENGINEERING_SWATH_VALUES] [ENGINEERING_STATES]);
  };

#endif
