/********** EngineeringTrain1TelemGroup.C *****************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh
   02/00   Tom Lauren

 $Log$

\**********************************************************************************************************************/

#include "EngineeringTrain1TelemGroup.h"

int const engineering_train1_telem_group::BLACKBODY_1_PRT_1_TEMPERATURE_OFFSET    = 0;
int const engineering_train1_telem_group::BLACKBODY_1_PRT_1_HIGH_REFERENCE_OFFSET = 2;
int const engineering_train1_telem_group::BLACKBODY_1_PRT_1_LOW_REFERENCE_OFFSET  = 4;
int const engineering_train1_telem_group::BLACKBODY_1_PRT_2_TEMPERATURE_OFFSET    = 6;
int const engineering_train1_telem_group::BLACKBODY_1_PRT_2_HIGH_REFERENCE_OFFSET = 8;
int const engineering_train1_telem_group::BLACKBODY_1_PRT_2_LOW_REFERENCE_OFFSET  = 10;
int const engineering_train1_telem_group::BLACKBODY_1_HEATER_VOLTAGE_OFFSET       = 208;
int const engineering_train1_telem_group::CHOPPER_1_TEMPERATURE_OFFSET            = 128;
int const engineering_train1_telem_group::LMC_1_GAS_TEMPERATURE_OFFSET            = 48;
int const engineering_train1_telem_group::LMC_1_PRESSURE_TEMPERATURE_OFFSET       = 164;
int const engineering_train1_telem_group::LMC_1_PRESSURE_OFFSET                   = 172;
int const engineering_train1_telem_group::LMC_1_PRESSURE_HIGH_REFERENCE_OFFSET    = 174;
int const engineering_train1_telem_group::LMC_1_PRESSURE_LOW_REFERENCE_OFFSET     = 176;
int const engineering_train1_telem_group::DETECTOR_1_TEMPERATURE_OFFSET           = 96;
int const engineering_train1_telem_group::DETECTOR_2_TEMPERATURE_OFFSET           = 98;
int const engineering_train1_telem_group::COLD_FILTER_1_TEMPERATURE_OFFSET        = 88;
int const engineering_train1_telem_group::SIEVE_1_TEMPERATURE_OFFSET              = 60;
int const engineering_train1_telem_group::SIEVE_1_HIGH_REFERENCE_OFFSET           = 62;
int const engineering_train1_telem_group::SIEVE_1_LOW_REFERENCE_OFFSET            = 64;
int const engineering_train1_telem_group::SIEVE_1_HEATER_VOLTAGE_OFFSET           = 216;
int const engineering_train1_telem_group::FIELDCOUNT                              = 20;

engineering_train1_telem_group :: engineering_train1_telem_group ()
                                : engineering_data_group ()
{
  ;
}


engineering_train1_telem_group :: ~engineering_train1_telem_group ()
{
  ;
}


void engineering_train1_telem_group :: AddBlock (unsigned char* blockdata)
{
  // make the container to hold the data we want
  unsigned short* telemdata = new unsigned short [FIELDCOUNT];

  // unpack the data
  telemdata [BLACKBODY_1_PRT_1_TEMPERATURE]    = UnpackData (&blockdata [BLACKBODY_1_PRT_1_TEMPERATURE_OFFSET]);
  telemdata [BLACKBODY_1_PRT_1_HIGH_REFERENCE] = UnpackData (&blockdata [BLACKBODY_1_PRT_1_HIGH_REFERENCE_OFFSET]);
  telemdata [BLACKBODY_1_PRT_1_LOW_REFERENCE]  = UnpackData (&blockdata [BLACKBODY_1_PRT_1_LOW_REFERENCE_OFFSET]);
  telemdata [BLACKBODY_1_PRT_2_TEMPERATURE]    = UnpackData (&blockdata [BLACKBODY_1_PRT_2_TEMPERATURE_OFFSET]);
  telemdata [BLACKBODY_1_PRT_2_HIGH_REFERENCE] = UnpackData (&blockdata [BLACKBODY_1_PRT_2_HIGH_REFERENCE_OFFSET]);
  telemdata [BLACKBODY_1_PRT_2_LOW_REFERENCE]  = UnpackData (&blockdata [BLACKBODY_1_PRT_2_LOW_REFERENCE_OFFSET]);
  telemdata [BLACKBODY_1_HEATER_VOLTAGE]       = UnpackData (&blockdata [BLACKBODY_1_HEATER_VOLTAGE_OFFSET]);
  telemdata [CHOPPER_1_TEMPERATURE]            = UnpackData (&blockdata [CHOPPER_1_TEMPERATURE_OFFSET]);
  telemdata [LMC_1_GAS_TEMPERATURE]            = UnpackData (&blockdata [LMC_1_GAS_TEMPERATURE_OFFSET]);
  telemdata [LMC_1_PRESSURE_TEMPERATURE]       = UnpackData (&blockdata [LMC_1_PRESSURE_TEMPERATURE_OFFSET]);
  telemdata [LMC_1_PRESSURE]                   = UnpackData (&blockdata [LMC_1_PRESSURE_OFFSET]);
  telemdata [LMC_1_PRESSURE_HIGH_REFERENCE]    = UnpackData (&blockdata [LMC_1_PRESSURE_HIGH_REFERENCE_OFFSET]);
  telemdata [LMC_1_PRESSURE_LOW_REFERENCE]     = UnpackData (&blockdata [LMC_1_PRESSURE_LOW_REFERENCE_OFFSET]);
  telemdata [DETECTOR_1_TEMPERATURE]           = UnpackData (&blockdata [DETECTOR_1_TEMPERATURE_OFFSET]);
  telemdata [DETECTOR_2_TEMPERATURE]           = UnpackData (&blockdata [DETECTOR_2_TEMPERATURE_OFFSET]);
  telemdata [COLD_FILTER_1_TEMPERATURE]        = UnpackData (&blockdata [COLD_FILTER_1_TEMPERATURE_OFFSET]);
  telemdata [SIEVE_1_TEMPERATURE]              = UnpackData (&blockdata [SIEVE_1_TEMPERATURE_OFFSET]);
  telemdata [SIEVE_1_HIGH_REFERENCE]           = UnpackData (&blockdata [SIEVE_1_HIGH_REFERENCE_OFFSET]);
  telemdata [SIEVE_1_LOW_REFERENCE]            = UnpackData (&blockdata [SIEVE_1_LOW_REFERENCE_OFFSET]);
  telemdata [SIEVE_1_HEATER_VOLTAGE]           = UnpackData (&blockdata [SIEVE_1_HEATER_VOLTAGE_OFFSET]);

  // add the container to the list
  datalist.AddData (telemdata);
}


bool engineering_train1_telem_group :: Define (int32 fileid, int32 groupid, string const& groupclass,
                                               string const& dataclass)
{
  string const fieldnames [FIELDCOUNT] = {"Blackbody 1 PRT 1 Temperature", "Blackbody 1 PRT 1 High Reference",
                                          "Blackbody 1 PRT 1 Low Reference", "Blackbody 1 PRT 2 Temperature",
                                          "Blackbody 1 PRT 2 High Reference", "Blackbody 1 PRT 2 Low Reference",
                                          "Blackbody 1 Heater Voltage", "Chopper 1 Temperature",
                                          "LMC 1 Gas Temperature", "LMC 1 Pressure Temperature", "LMC 1 Pressure",
                                          "LMC 1 Pressure High Reference", "LMC 1 Pressure Low Reference",
                                          "Detector 1 Temperature", "Detector 2 Temperature", 
                                          "Cold Filter 1 Temperature", "Sieve 1 Temperature", "Sieve 1 High Reference",
                                          "Sieve 1 Low Reference", "Sieve 1 Heater Voltage"};
  int32 const datatypes [FIELDCOUNT] = {DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16,
                                        DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16,
                                        DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16,
                                        DFNT_UINT16, DFNT_UINT16};
  int32 const orders [FIELDCOUNT] = {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};

  return engineering_data_group::Define (fileid, groupid, "Engineering Train1 Telem Group", groupclass,
                                         "Engineering Train1 Telem Data", dataclass, FIELDCOUNT, fieldnames, datatypes,
                                         orders);
}


float engineering_train1_telem_group :: GetEventTemperature (int startindex, int stopindex, mopip_file const& mopipfile)
{
  // get the average readings for bb1 temp, hi ref and lo ref; use mopip to convert to units
  float bb1sensor [ENGINEERING_STATES], bb1hiref [ENGINEERING_STATES], bb1loref [ENGINEERING_STATES];
  datalist.GetAverageValue ((int) BLACKBODY_1_PRT_1_TEMPERATURE,    startindex, stopindex, bb1sensor);
  datalist.GetAverageValue ((int) BLACKBODY_1_PRT_1_HIGH_REFERENCE, startindex, stopindex, bb1hiref);
  datalist.GetAverageValue ((int) BLACKBODY_1_PRT_1_LOW_REFERENCE,  startindex, stopindex, bb1loref);
  float bb1temp [ENGINEERING_STATES];
  mopipfile.Compute (BlackbodyTemperature1_1, bb1sensor, bb1hiref, bb1loref, bb1temp);

  // get the average readings for bb2 temp, hi ref and lo ref; use mopip to convert to units
  float bb2sensor [ENGINEERING_STATES], bb2hiref [ENGINEERING_STATES], bb2loref [ENGINEERING_STATES];
  datalist.GetAverageValue ((int) BLACKBODY_1_PRT_2_TEMPERATURE,    startindex, stopindex, bb2sensor);
  datalist.GetAverageValue ((int) BLACKBODY_1_PRT_2_HIGH_REFERENCE, startindex, stopindex, bb2hiref);
  datalist.GetAverageValue ((int) BLACKBODY_1_PRT_2_LOW_REFERENCE,  startindex, stopindex, bb2loref);
  float bb2temp [ENGINEERING_STATES];
  mopipfile.Compute (BlackbodyTemperature1_2, bb2sensor, bb2hiref, bb2loref, bb2temp);

  return ((bb1temp [ENGINEERING_AVERAGE_VALUE] + bb2temp [ENGINEERING_AVERAGE_VALUE]) / 2.0);
}


void engineering_train1_telem_group :: GetSummaryData (int startindex, int stopindex, mopip_file const& mopipfile, 
                                                       float diodehighrefs [DIODE_BANKS] [ENGINEERING_STATES], 
                                                       float diodelowrefs [DIODE_BANKS] [ENGINEERING_STATES], 
                                                       float thermistorhighrefs [THERMISTOR_BANKS] [ENGINEERING_STATES],
                                                       float thermistorlowrefs [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                                    float summarydata [ENGINEERING_SUMMARY_VALUES] [ENGINEERING_STATES])
{
  float sensor [ENGINEERING_STATES], highref [ENGINEERING_STATES], lowref [ENGINEERING_STATES];
  short bank;

  datalist.GetAverageValue ((int) BLACKBODY_1_PRT_1_TEMPERATURE, startindex, stopindex, sensor);
  datalist.GetAverageValue ((int) BLACKBODY_1_PRT_1_HIGH_REFERENCE, startindex, stopindex, highref);
  datalist.GetAverageValue ((int) BLACKBODY_1_PRT_1_LOW_REFERENCE,  startindex, stopindex, lowref);
  mopipfile.Compute (BlackbodyTemperature1_1, sensor, highref, lowref, summarydata[SUMMARY_BLACKBODY_1_TEMPERATURE_1]);

  datalist.GetAverageValue ((int) BLACKBODY_1_PRT_2_TEMPERATURE, startindex, stopindex, sensor);
  datalist.GetAverageValue ((int) BLACKBODY_1_PRT_2_HIGH_REFERENCE, startindex, stopindex, highref);
  datalist.GetAverageValue ((int) BLACKBODY_1_PRT_2_LOW_REFERENCE,  startindex, stopindex, lowref);
  mopipfile.Compute (BlackbodyTemperature1_2, sensor, highref, lowref, summarydata[SUMMARY_BLACKBODY_1_TEMPERATURE_2]);

  datalist.GetAverageValue ((int) BLACKBODY_1_HEATER_VOLTAGE, startindex, stopindex, sensor);
  mopipfile.Compute (BlackbodyHeaterVoltage1, sensor, summarydata[SUMMARY_BLACKBODY_1_HEATER_VOLTAGE]);

  datalist.GetAverageValue ((int) CHOPPER_1_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (ChopperTemperature1);
  mopipfile.Compute (ChopperTemperature1, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     summarydata[SUMMARY_CHOPPER_1_TEMPERATURE]);

  datalist.GetAverageValue ((int) LMC_1_GAS_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (LMCTemperature1);
  mopipfile.Compute (LMCTemperature1, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     summarydata[SUMMARY_LMC_1_TEMPERATURE]);

  datalist.GetAverageValue ((int) LMC_1_PRESSURE_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (LMCPressureTemperature1);
  mopipfile.Compute (LMCPressureTemperature1, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     summarydata[SUMMARY_LMC_1_PRESSURE_TEMPERATURE]);

  datalist.GetAverageValue ((int) LMC_1_PRESSURE,                startindex, stopindex, sensor);
  datalist.GetAverageValue ((int) LMC_1_PRESSURE_HIGH_REFERENCE, startindex, stopindex, highref);
  datalist.GetAverageValue ((int) LMC_1_PRESSURE_LOW_REFERENCE,  startindex, stopindex, lowref);
  mopipfile.Compute (LMCPressure1, sensor, highref, lowref, summarydata[SUMMARY_LMC_1_PRESSURE]);

  datalist.GetAverageValue ((int) DETECTOR_1_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (DetectorTemperature1);
  mopipfile.Compute (DetectorTemperature1, sensor, diodehighrefs[bank - 1], diodelowrefs[bank - 1],
                     summarydata[SUMMARY_DETECTOR_1_TEMPERATURE]);

  datalist.GetAverageValue ((int) DETECTOR_2_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (DetectorTemperature2);
  mopipfile.Compute (DetectorTemperature2, sensor, diodehighrefs[bank - 1], diodelowrefs[bank - 1],
                     summarydata[SUMMARY_DETECTOR_2_TEMPERATURE]);

  datalist.GetAverageValue ((int) COLD_FILTER_1_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (ColdFilterTemperature1);
  mopipfile.Compute (ColdFilterTemperature1, sensor, diodehighrefs[bank - 1], diodelowrefs[bank - 1],
                     summarydata[SUMMARY_COLD_FILTER_1_TEMPERATURE]);

  datalist.GetAverageValue ((int) SIEVE_1_TEMPERATURE, startindex, stopindex, sensor);
  datalist.GetAverageValue ((int) SIEVE_1_HIGH_REFERENCE, startindex, stopindex, highref);
  datalist.GetAverageValue ((int) SIEVE_1_LOW_REFERENCE,  startindex, stopindex, lowref);
  mopipfile.Compute (SieveTemperature1, sensor, highref, lowref, summarydata[SUMMARY_SIEVE_1_TEMPERATURE]);

  datalist.GetAverageValue ((int) SIEVE_1_HEATER_VOLTAGE, startindex, stopindex, sensor);
  mopipfile.Compute (SieveHeaterVoltage1, sensor, summarydata[SUMMARY_SIEVE_1_HEATER_VOLTAGE]);
}


void engineering_train1_telem_group :: GetSwathData (int startindex, int stopindex, mopip_file const& mopipfile, 
                                                     float diodehighrefs [DIODE_BANKS] [ENGINEERING_STATES], 
                                                     float diodelowrefs [DIODE_BANKS] [ENGINEERING_STATES], 
                                                     float thermistorhighrefs [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                                     float thermistorlowrefs [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                                     float swathdata [ENGINEERING_SWATH_VALUES] [ENGINEERING_STATES])
{
  float sensor [ENGINEERING_STATES], highref [ENGINEERING_STATES], lowref [ENGINEERING_STATES];
  short bank;

  datalist.GetAverageValue ((int) CHOPPER_1_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (ChopperTemperature1);
  mopipfile.Compute (ChopperTemperature1, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     swathdata[SWATH_CHOPPER_1_TEMPERATURE]);

  datalist.GetAverageValue ((int) COLD_FILTER_1_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (ColdFilterTemperature1);
  mopipfile.Compute (ColdFilterTemperature1, sensor, diodehighrefs[bank - 1], diodelowrefs[bank - 1],
                     swathdata[SWATH_COLDFILTER_1_TEMPERATURE]);

  datalist.GetAverageValue ((int) DETECTOR_1_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (DetectorTemperature1);
  mopipfile.Compute (DetectorTemperature1, sensor, diodehighrefs[bank - 1], diodelowrefs[bank - 1],
                     swathdata[SWATH_DETECTOR_1_TEMPERATURE]);

  datalist.GetAverageValue ((int) DETECTOR_2_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (DetectorTemperature2);
  mopipfile.Compute (DetectorTemperature2, sensor, diodehighrefs[bank - 1], diodelowrefs[bank - 1],
                     swathdata[SWATH_DETECTOR_2_TEMPERATURE]);

  datalist.GetAverageValue ((int) LMC_1_GAS_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (LMCTemperature1);
  mopipfile.Compute (LMCTemperature1, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     swathdata[SWATH_LMC_1_SHROUD_TEMPERATURE]);

  datalist.GetAverageValue ((int) LMC_1_PRESSURE_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (LMCPressureTemperature1);
  mopipfile.Compute (LMCPressureTemperature1, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     swathdata[SWATH_LMC_1_PRESSURE_TEMPERATURE]);

  datalist.GetAverageValue ((int) LMC_1_PRESSURE,                startindex, stopindex, sensor);
  datalist.GetAverageValue ((int) LMC_1_PRESSURE_HIGH_REFERENCE, startindex, stopindex, highref);
  datalist.GetAverageValue ((int) LMC_1_PRESSURE_LOW_REFERENCE,  startindex, stopindex, lowref);
  mopipfile.Compute (LMCPressure1, sensor, highref, lowref, swathdata[SWATH_LMC_1_PRESSURE]);
}
