/********** EngineeringTrain1Data.C ***********************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "EngineeringTrain1Data.h"

engineering_train1_data :: engineering_train1_data ()
                         : telemgroup ()
                         , block4group ()
                         , block5group ()
                         , vgroup ()
{
}


engineering_train1_data :: ~engineering_train1_data ()
{
  ;
}


void engineering_train1_data :: AddBlock (engineering_block* engineeringblock)
{
  // add the data to the telem group
  unsigned char* telemdata = engineeringblock->GetTelemData ();
  telemgroup.AddBlock (telemdata);

  // if necessary, add the block data to the appropriate group
  unsigned char* blockdata;
  switch (engineeringblock->GetBlockNumber ()) {
    case 4 : blockdata = engineeringblock->GetHouseData ();
             block4group.AddBlock (blockdata);
             break;
    case 5 : blockdata = engineeringblock->GetHouseData ();
             block5group.AddBlock (blockdata);
             break;
    default : break;
  }
}


bool engineering_train1_data :: Close ()
{
  bool isclosed = false;

  if (telemgroup.Close ())
    if (block4group.Close ())
      if (block5group.Close ())
        if (vgroup.Close ())
          isclosed = true;

  return isclosed;
}


bool engineering_train1_data :: Define (int32 fileid, int32 engineeringid, string const& maingroupclass) 
{
  bool isdefined = false;
  string const groupclass = "Engineering Train1 Group";
  string const dataclass  = "Engineering Train1 Data";

  if (vgroup.Create (groupclass, maingroupclass, fileid))
    if (telemgroup.Define (fileid, vgroup.GetID (), groupclass, dataclass))
      if (block4group.Define (fileid, vgroup.GetID (), groupclass, dataclass))
        if (block5group.Define (fileid, vgroup.GetID (), groupclass, dataclass))
          if (vgroup.Insert (engineeringid))
            isdefined = true;
    
  return isdefined;
}


float engineering_train1_data :: GetEventTemperature (int startindex, int stopindex, mopip_file const& mopipfile)
{
  return telemgroup.GetEventTemperature (startindex, stopindex, mopipfile);
}


void engineering_train1_data :: GetTelemSummaryData (int startindex, int stopindex, mopip_file const& mopipfile,
                                                      float diodehighrefs [DIODE_BANKS] [ENGINEERING_STATES], 
                                                      float diodelowrefs [DIODE_BANKS] [ENGINEERING_STATES],
                                                      float thermistorhighrefs [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                                      float thermistorlowrefs [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                              float summaryengineering [ENGINEERING_SUMMARY_VALUES][ENGINEERING_STATES])
{
  telemgroup.GetSummaryData (startindex, stopindex, mopipfile, diodehighrefs, diodelowrefs, thermistorhighrefs,
                             thermistorlowrefs, summaryengineering);
}


void engineering_train1_data :: GetBlock4SummaryData (int startindex, int stopindex, mopip_file const& mopipfile,
                                              float summaryengineering [ENGINEERING_SUMMARY_VALUES][ENGINEERING_STATES])
{
  block4group.GetSummaryData (startindex, stopindex, mopipfile, summaryengineering);
}


void engineering_train1_data :: GetBlock5SummaryData (int startindex, int stopindex, mopip_file const& mopipfile,
                                                      float thermistorhighrefs [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                                      float thermistorlowrefs [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                              float summaryengineering [ENGINEERING_SUMMARY_VALUES][ENGINEERING_STATES])
{
  block5group.GetSummaryData (startindex, stopindex, mopipfile, thermistorhighrefs, thermistorlowrefs, 
                              summaryengineering);
}


void engineering_train1_data :: GetSwathData (int startindex, int stopindex, mopip_file const& mopipfile,
                                              float diodehighrefs [DIODE_BANKS] [ENGINEERING_STATES], 
                                              float diodelowrefs [DIODE_BANKS] [ENGINEERING_STATES],
                                              float thermistorhighrefs [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                              float thermistorlowrefs [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                              float swathengineering [ENGINEERING_SWATH_VALUES][ENGINEERING_STATES])
{
  telemgroup.GetSwathData (startindex, stopindex, mopipfile, diodehighrefs, diodelowrefs, thermistorhighrefs,
                           thermistorlowrefs, swathengineering);
}


bool engineering_train1_data :: Write ()
{
  bool iswritten = false;

  if (telemgroup.Write ())
    if (block4group.Write ())
      if (block5group.Write ())
        iswritten = true;

  return iswritten;
}
