/********** EngineeringTrain1Block4Group.C ****************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "EngineeringTrain1Block4Group.h"

int const engineering_train1_block4_group::MIRROR_1_MOTOR_CURRENT_OFFSET  = 10;
int const engineering_train1_block4_group::CHOPPER_1_MOTOR_CURRENT_OFFSET = 18;
int const engineering_train1_block4_group::LMC_1_MOTOR_CURRENT_OFFSET     = 26;
int const engineering_train1_block4_group::FIELDCOUNT                     = 3;

engineering_train1_block4_group :: engineering_train1_block4_group ()
                                 : engineering_data_group ()
{
  ;
}


engineering_train1_block4_group :: ~engineering_train1_block4_group ()
{
  ;
}


void engineering_train1_block4_group :: AddBlock (unsigned char* blockdata)
{
  // make the container to hold the data we want
  unsigned short* housedata = new unsigned short [FIELDCOUNT];

  // unpack the data
  housedata [MIRROR_1_MOTOR_CURRENT]  = UnpackData (&blockdata [MIRROR_1_MOTOR_CURRENT_OFFSET]);
  housedata [CHOPPER_1_MOTOR_CURRENT] = UnpackData (&blockdata [CHOPPER_1_MOTOR_CURRENT_OFFSET]);
  housedata [LMC_1_MOTOR_CURRENT]     = UnpackData (&blockdata [LMC_1_MOTOR_CURRENT_OFFSET]);

  // add the container to the list
  datalist.AddData (housedata);
}


bool engineering_train1_block4_group :: Define (int32 fileid, int32 groupid, string const& groupclass,
                                                string const& dataclass)
{
  string const fieldnames [FIELDCOUNT] = {"Mirror 1 Motor Current", "Chopper 1 Motor Current", "LMC 1 Motor Current"};
  int32 const datatypes [FIELDCOUNT] = {DFNT_UINT16, DFNT_UINT16, DFNT_UINT16};
  int32 const orders [FIELDCOUNT] = {1, 1, 1};

  return engineering_data_group::Define (fileid, groupid, "Engineering Train1 Block4 Group", groupclass,
                                         "Engineering Train1 Block4 Data", dataclass, FIELDCOUNT, fieldnames, 
                                         datatypes, orders);
}


void engineering_train1_block4_group :: GetSummaryData (int startindex, int stopindex, mopip_file const& mopipfile, 
                                                    float summarydata [ENGINEERING_SUMMARY_VALUES] [ENGINEERING_STATES])
{
  float sensor [ENGINEERING_STATES];

  datalist.GetAverageValue ((int) MIRROR_1_MOTOR_CURRENT, startindex, stopindex, sensor);
  mopipfile.Compute (MirrorMotorCurrent1, sensor, summarydata[SUMMARY_MIRROR_1_MOTOR_CURRENT]);

  datalist.GetAverageValue ((int) CHOPPER_1_MOTOR_CURRENT, startindex, stopindex, sensor);
  mopipfile.Compute (ChopperMotorCurrent1, sensor, summarydata[SUMMARY_CHOPPER_1_MOTOR_CURRENT]);

  datalist.GetAverageValue ((int) LMC_1_MOTOR_CURRENT, startindex, stopindex, sensor);
  mopipfile.Compute (LMCMotorCurrent1, sensor, summarydata[SUMMARY_LMC_1_MOTOR_CURRENT]);
}
