/********** EngineeringTimeList.C *************************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "EngineeringTimeList.h"

engineering_time_list :: engineering_time_list ()
                       : timelist ()
{
  next = 0;
}


engineering_time_list :: ~engineering_time_list ()
{
  // make sure the list is empty
  mopitt_time* engtime;
  while (! timelist.empty ()) {
    engtime = timelist.front ();
    delete engtime;
    timelist.pop_front ();
  }
}


void engineering_time_list :: AddTime (mopitt_time* engtime)
{
  timelist.push_back (engtime);
}


bool engineering_time_list :: GetIndeces (mopitt_time const& starttime, mopitt_time const& stoptime, int& startindex, 
                                          int& stopindex)
{
  bool foundoverlappingblocks = true;

  // find the index for the start time
  bool keeplooking = true;
  deque <mopitt_time*> :: iterator iter;
  for (iter = timelist.begin () + startindex; iter != timelist.end () && keeplooking; iter++)
    if (starttime > *(*iter))
      startindex++;
    else
      keeplooking = false;

  if (keeplooking && iter == timelist.end ())
    startindex--;

  // now find the index for the stop time
  keeplooking = true;
  stopindex = startindex;
  for (iter = timelist.begin () + stopindex; iter != timelist.end () && keeplooking; iter++)
    if (stoptime > *(*iter))
      stopindex++;
    else
      keeplooking = false;

  if (keeplooking && iter == timelist.end ())
    stopindex--;
  else {
    iter = timelist.begin () + stopindex;
    if (stopindex > 0 && stoptime != *(*iter))
      stopindex--;
  }

  // when the times do not overlap any points, the indeces will be reversed, so make sure to swap them
  if (stopindex < startindex) {
    int tempindex = startindex;
    startindex = stopindex;
    stopindex = tempindex;
  }

  // set flag if indeces aren't within time range
  if (startindex == stopindex) {
    if (*(*(timelist.begin () + startindex)) < starttime || *(*(timelist.begin () + stopindex)) > stoptime)
      foundoverlappingblocks = false;
  }
  else if ((stopindex - startindex) == 1) {
    if (*(*(timelist.begin () + startindex)) < starttime && *(*(timelist.begin () + stopindex)) > stoptime)
      foundoverlappingblocks = false;
  }

  return foundoverlappingblocks;
}


bool engineering_time_list :: GetNext (mopitt_time** mopitttime)
{
  bool isfound = false;
 
  deque <mopitt_time*> :: const_iterator iter = timelist.begin () + next;
  if (iter != timelist.end ()) {
    *mopitttime = (mopitt_time*) (*iter);
    isfound = true;
    next++;
  }

  return isfound;
}
