/********** EngineeringTimeGroup.C ************************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "EngineeringTimeGroup.h"

engineering_time_group :: engineering_time_group ()
                        : timelist ()
                        , vgroup ()
                        , vdata ()
{
  ;
}


engineering_time_group :: ~engineering_time_group ()
{
  ;
}


void engineering_time_group :: AddTime (mopitt_time* engtime)
{
  timelist.AddTime (engtime);
}


bool engineering_time_group :: Close ()
{
  bool isclosed = false;

  if (vdata.Close ())
    if (vgroup.Close ())
      isclosed = true;

  return isclosed;
}


bool engineering_time_group :: Define (int32 fileid, int32 groupid, string const& grouptype)
{
  bool isdefined = false;
  string groupname = "Engineering Time ";
  groupname += grouptype;
  groupname += " Group";
  string dataname = "Engineering Time ";
  dataname += grouptype;
  dataname += " Data";
  string const fieldnames [2] = {"Days", "Milliseconds"};
  int32 const datatypes [2] = {DFNT_INT32, DFNT_INT32};
  int32 const orders [2] = {1,1};

  if (vgroup.Create (groupname.c_str (), "Engineering Time Group", fileid))
    if (vdata.Create (dataname.c_str (), "Engineering Time Data", fileid))
      if (vdata.Define (2, datatypes, orders, fieldnames))
        if (vdata.Set (2, fieldnames))
          if (vdata.Insert (vgroup.GetID ()))
            if (vgroup.Insert (groupid))
              isdefined = true;

  return isdefined;
}
    

bool engineering_time_group :: GetIndeces (mopitt_time const& starttime, mopitt_time const& stoptime, 
                                           int& startindex, int& stopindex)
{
  return timelist.GetIndeces (starttime, stoptime, startindex, stopindex);
}


bool engineering_time_group :: Write ()
{
  bool iswritten = true;
  mopitt_time* mopitttime = NULL;
  int timedata [2];

  // while there are no errors AND there are trains in the list
  while (iswritten && timelist.GetNext (&mopitttime)) {

    // get the data
    timedata [0] = mopitttime->GetDay ();
    timedata [1] = mopitttime->GetMsecs ();

    // write the data
    if (! vdata.Write ((void*) timedata))
      iswritten = false;
  }

  return iswritten;
}
