/********** EngineeringTimeData.h *************************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_ENGINEERING_TIME_DATA_

  #define _MOPITT_L1_ENGINEERING_TIME_DATA_

  #include "EngineeringBlock.h"
  #include "EngineeringTimeGroup.h"

  class engineering_time_data {
    private :
      engineering_time_group telemgroup;
      engineering_time_group block3group;
      engineering_time_group block4group;
      engineering_time_group block5group;
      engineering_time_group block8group;
      hdf_vgroup             vgroup;

    protected :

    public :
      engineering_time_data ();
      ~engineering_time_data ();

      void AddBlock         (engineering_block*);
      bool Close            ();
      bool Define           (int32, int32, string const&);
      bool GetTelemIndeces  (mopitt_time const&, mopitt_time const&, int&, int&);
      bool GetBlock3Indeces (mopitt_time const&, mopitt_time const&, int&, int&);
      bool GetBlock4Indeces (mopitt_time const&, mopitt_time const&, int&, int&);
      bool GetBlock5Indeces (mopitt_time const&, mopitt_time const&, int&, int&);
      bool GetBlock8Indeces (mopitt_time const&, mopitt_time const&, int&, int&);
      bool Write            ();
  };

#endif
