/********** EngineeringTimeData.C *************************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "EngineeringTimeData.h"

engineering_time_data :: engineering_time_data ()
                       : telemgroup ()
                       , block3group ()
                       , block4group ()
                       , block5group ()
                       , block8group ()
                       , vgroup ()
{
  ;
}


engineering_time_data :: ~engineering_time_data ()
{
  ;
}


void engineering_time_data :: AddBlock (engineering_block* engineeringblock)
{
  // make a copy of the block time and add it to the telem time group
  mopitt_time* telemtime = new mopitt_time ((engineeringblock->GetTime ()).GetTAI ());
  telemgroup.AddTime (telemtime);

  // if necessary, make another copy of the block time and add it to the appropriate group
  mopitt_time* blocktime;
  switch (engineeringblock->GetBlockNumber ()) {
    case 3 : blocktime = new mopitt_time ((engineeringblock->GetTime ()).GetTAI ());
             block3group.AddTime (blocktime);
             break;
    case 4 : blocktime = new mopitt_time ((engineeringblock->GetTime ()).GetTAI ());
             block4group.AddTime (blocktime);
             break;
    case 5 : blocktime = new mopitt_time ((engineeringblock->GetTime ()).GetTAI ());
             block5group.AddTime (blocktime);
             break;
    case 8 : blocktime = new mopitt_time ((engineeringblock->GetTime ()).GetTAI ());
             block8group.AddTime (blocktime);
             break;
    default : break;
  }
}


bool engineering_time_data :: Close ()
{
  bool isclosed = false;

  if (telemgroup.Close ())
    if (block3group.Close ())
      if (block4group.Close ())
        if (block5group.Close ())
          if (block8group.Close ())
            if (vgroup.Close ())
              isclosed = true;

  return isclosed;
}


bool engineering_time_data :: Define (int32 fileid, int32 engineeringid, string const& groupclass) 
{
  bool isdefined = false;

  if (vgroup.Create ("Engineering Time Group", groupclass, fileid))
    if (telemgroup.Define  (fileid, vgroup.GetID (), "Telem"))
      if (block3group.Define (fileid, vgroup.GetID (), "Block 3"))
        if (block4group.Define (fileid, vgroup.GetID (), "Block 4"))
          if (block5group.Define (fileid, vgroup.GetID (), "Block 5"))
            if (block8group.Define (fileid, vgroup.GetID (), "Block 8"))
              if (vgroup.Insert (engineeringid))
                isdefined = true;

  return isdefined;
}


bool engineering_time_data :: GetTelemIndeces (mopitt_time const& starttime, mopitt_time const& stoptime, 
                                               int& startindex, int& stopindex)
{
  return telemgroup.GetIndeces (starttime, stoptime, startindex, stopindex);
}


bool engineering_time_data :: GetBlock3Indeces (mopitt_time const& starttime, mopitt_time const& stoptime, 
                                                int& startindex, int& stopindex)
{
  return block3group.GetIndeces (starttime, stoptime, startindex, stopindex);
}


bool engineering_time_data :: GetBlock4Indeces (mopitt_time const& starttime, mopitt_time const& stoptime, 
                                                int& startindex, int& stopindex)
{
  return block4group.GetIndeces (starttime, stoptime, startindex, stopindex);
}


bool engineering_time_data :: GetBlock5Indeces (mopitt_time const& starttime, mopitt_time const& stoptime, 
                                                int& startindex, int& stopindex)
{
  return block5group.GetIndeces (starttime, stoptime, startindex, stopindex);
}


bool engineering_time_data :: GetBlock8Indeces (mopitt_time const& starttime, mopitt_time const& stoptime, 
                                                int& startindex, int& stopindex)
{
  return block8group.GetIndeces (starttime, stoptime, startindex, stopindex);
}


bool engineering_time_data :: Write ()
{
  bool iswritten = false;

  if (telemgroup.Write ())
    if (block3group.Write ())
      if (block4group.Write ())
        if (block5group.Write ())
          if (block8group.Write ()) 
            iswritten = true;

  return iswritten;
}
