/********** EngineeringPacket.C ***************************************************************************************\

 $Header$

 REVISION HISTORY
   12/98   Charles Cavanaugh
   05/00   Daniel Ziskin

 $Log$

\**********************************************************************************************************************/

#include "EngineeringPacket.h"
#include "DiagnosticReporter.h"

extern diagnostic_reporter diagnosticreporter;

engineering_packet :: engineering_packet ()
                    : l0_packet ()
{
  offset = PACKET_APPLICATION_DATA_START;
}


engineering_packet :: engineering_packet (PGSt_IO_L0_Packet* data)
                    : l0_packet (data)
{
  offset = PACKET_APPLICATION_DATA_START;
}


engineering_packet :: ~engineering_packet ()
{
  ;
}


engineering_block* engineering_packet :: GetBlock (PGSt_PC_Logical currentlogical, int sequence)
{
  engineering_block* engineeringblock = NULL;

  // make sure there is a complete block to return
  if ((offset + ENGINEERING_BLOCK_SIZE) <= (length + 16)) {

    // make a block object
    engineeringblock = new engineering_block (time, &data[offset], currentlogical, sequence);

    // increment the offset
    offset += ENGINEERING_BLOCK_SIZE;
  }

  return engineeringblock;
}
